/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intel_hex;

import com.microchip.helper.Helper;
import com.microchip.intel_hex.HexException;
import com.microchip.intel_hex.HexRecordType;

public class HexRecord {
    private final int LENGTH_OFFSET = 1;
    private final int ADDRESS_OFFSET = 3;
    private final int TYPE_OFFSET = 7;
    private final int DATA_OFFET = 9;
    private int address;
    private int length;
    private HexRecordType type;
    private byte[] data;

    public HexRecord(String record) throws HexException {
        this.type = HexRecordType.getRecordType(record);
        if (this.type == null) {
            throw new HexException("Invalid HEX Record");
        }
        char[] recordBuffer = record.toCharArray();
        this.length = Helper.asciiHexToByte(recordBuffer, 1) & 0xFF;
        this.address = Helper.asciiHexToShort(recordBuffer, 3) & 0xFFFF;
        this.data = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = Helper.asciiHexToByte(recordBuffer, 9 + i * 2);
        }
    }

    public HexRecordType getRecordType() {
        return this.type;
    }

    public int getDataLength() {
        return this.length;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }
}

