/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.models.ServerRequest;
import com.azul.crs.client.service.JarLoadService;
import com.azul.crs.util.logging.Logger;

public final class VmJarInfoRequestSupport {
    private VmJarInfoRequestSupport() {
    }

    static VmJarInfoRequest decodeVmJarInfoRequest(String string) {
        String[] stringArray = string.split("\\|");
        VmJarInfoRequestCookie vmJarInfoRequestCookie = null;
        VmJarInfoRequest.DetailsLevel detailsLevel = VmJarInfoRequest.DetailsLevel.ALL_HASHES;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split("=", 2);
            try {
                if (stringArray2.length != 2) continue;
                switch (stringArray2[0]) {
                    case "cookie": {
                        vmJarInfoRequestCookie = (VmJarInfoRequestCookie)new VmJarInfoRequestCookie().decode(stringArray2[1]);
                        break;
                    }
                    case "detailsLevel": {
                        detailsLevel = VmJarInfoRequest.DetailsLevel.valueOf(stringArray2[1]);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                VmJarInfoRequestSupport.logger().trace("exception on decodeVmJarInfoRequest %s", exception);
            }
        }
        return vmJarInfoRequestCookie == null ? null : new VmJarInfoRequest(vmJarInfoRequestCookie, detailsLevel);
    }

    private static Logger logger() {
        return Logger.getLogger(JarLoadService.class);
    }

    public static final class VmJarInfoRequestCookie
    extends ServerRequest.RequestCookie<VmJarInfoRequestCookie> {
        static final int COOKIE_PROPERTIES_NUMBER = 3;
        static final int PATH_POS = 0;
        static final int URL_POS = 1;
        static final int HASH_POS = 2;

        public VmJarInfoRequestCookie(String string, String string2, String string3) {
            super(new String[]{string, string2, string3});
            assert (this.data.length == 3);
            assert (this.data[0] == string);
            assert (this.data[1] == string2);
            assert (this.data[2] == string3);
        }

        private VmJarInfoRequestCookie() {
            super(new String[3]);
            assert (this.data.length == 3);
        }

        public String getPath() {
            return this.data[0];
        }

        public String getUrl() {
            return this.data[1];
        }

        public String getCDHash() {
            return this.data[2];
        }

        static {
            VmJarInfoRequest.registerDecoder();
        }
    }

    public static final class VmJarInfoRequest
    extends ServerRequest {
        private final DetailsLevel detailsLevel;
        private final VmJarInfoRequestCookie cookie;

        private static void registerDecoder() {
            ServerRequest.registerDecoder("VmJarInfoRequest", VmJarInfoRequestSupport::decodeVmJarInfoRequest);
        }

        private VmJarInfoRequest(VmJarInfoRequestCookie vmJarInfoRequestCookie, DetailsLevel detailsLevel) {
            this.cookie = vmJarInfoRequestCookie;
            this.detailsLevel = detailsLevel;
        }

        public String getUrl() {
            return this.cookie.getUrl();
        }

        public String getPath() {
            return this.cookie.getPath();
        }

        public String getCDHash() {
            return this.cookie.getCDHash();
        }

        public DetailsLevel getDetailsLevel() {
            return this.detailsLevel;
        }

        public String toString() {
            return "VmJarInfoRequest: " + String.join((CharSequence)"|", this.getPath(), this.getUrl(), this.getCDHash(), this.detailsLevel.name());
        }

        public static enum DetailsLevel {
            NONE,
            ALL_HASHES;

        }
    }
}

