/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.InterfaceConnectionManager;
import com.azul.crs.client.Response;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.ConfigurationUpdatingService;
import com.azul.crs.client.service.QueueService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;

public class EventService
implements ClientService {
    private final Client client;
    private final QueueService<VMEvent> queue;

    private EventService(Client client) {
        this.client = client;
        this.queue = new QueueService.Builder().maxQueueSize(Tweaks.MAX_QUEUE_SIZE).maxBatchSize(Tweaks.BATCH_SIZE).maxWorkers(Tweaks.MAX_WORKERS).processBatch(this::postWithRetries).name("EVENT").build();
    }

    public static EventService getInstance(Client client) {
        return new EventService(client);
    }

    public void add(VMEvent vMEvent) {
        VMEvent.Type type = vMEvent.getEventType();
        int n = type.incrementInFlightEventsCount();
        boolean bl = this.queue.add(vMEvent);
        if (!bl) {
            n = type.subtractInFlightEventsCount(1);
            vMEvent.callOnError();
        }
        if (Tweaks.DEBUG_EVENT_SERVICE) {
            this.logger().trace("Queue %s: Event of type %s %s added. [InFlightEventsCount=%d]", new Object[]{this.queue.serviceName(), type, bl ? "was" : "was not", n});
        }
    }

    public void addAll(Collection<VMEvent> collection) {
        collection.forEach(this::add);
    }

    @Override
    public String serviceName() {
        return "client.service.Events";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    public void cancel() {
        this.queue.cancel();
    }

    public void connectionEstablished() {
        this.queue.start();
    }

    private Collection<VMEvent> filterOutAndSendBeforeTheBatchVMCreateEvent(String string, Collection<VMEvent> collection) {
        if (collection.size() == 1 && collection.stream().findFirst().get().getEventType() == VMEvent.Type.VM_CREATE) {
            return collection;
        }
        return collection.stream().filter(vMEvent -> {
            switch (vMEvent.getEventType()) {
                case VM_CREATE: {
                    this.postWithRetries(string, Collections.singleton(vMEvent));
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private Collection<VMEvent> filterOutUnnecessaryEventsBasedOnFeatureFlagsFilter(Collection<VMEvent> collection) {
        return collection.stream().filter(vMEvent -> {
            switch (vMEvent.getEventType()) {
                case VM_JAR_LOADED: {
                    boolean bl = ConfigurationUpdatingService.getSendJarLoads();
                    if (!bl) {
                        vMEvent.callOnError();
                    }
                    return bl;
                }
                case VM_CLASS_LOADED: {
                    return ConfigurationUpdatingService.getSendClassLoads();
                }
                case VM_METHOD_FIRST_CALLED: {
                    return ConfigurationUpdatingService.getSendFirstMethods();
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postWithRetries(String string, Collection<VMEvent> collection) {
        this.logger().trace("event worker tries to post batch of %,d VM events", collection.size());
        boolean bl = false;
        collection = this.filterOutAndSendBeforeTheBatchVMCreateEvent(string, collection);
        Collection<VMEvent> collection2 = collection = this.filterOutUnnecessaryEventsBasedOnFeatureFlagsFilter(collection);
        try {
            Iterator<VMEvent> iterator = this.client.getConnectionManager();
            bl = iterator.requestWithRetries(() -> EventService.lambda$postWithRetries$2((InterfaceConnectionManager)((Object)iterator), collection2), "postEventBatch", Tweaks.EVENT_MAX_RETRIES, Tweaks.EVENT_RETRY_SLEEP);
            collection2.stream().collect(Collectors.groupingBy(vMEvent -> vMEvent.getEventType(), Collectors.counting())).forEach((type, l) -> type.subtractInFlightEventsCount(l.intValue()));
        }
        catch (Throwable throwable) {
            collection2.stream().collect(Collectors.groupingBy(vMEvent -> vMEvent.getEventType(), Collectors.counting())).forEach((type, l) -> type.subtractInFlightEventsCount(l.intValue()));
            for (VMEvent vMEvent2 : collection2) {
                try {
                    if (!Tweaks.DEBUG_EVENT_SERVICE) continue;
                    System.out.println(">>> succeed=" + bl + ", e=" + vMEvent2);
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
            }
            if (bl) {
                for (VMEvent vMEvent2 : collection2) {
                    try {
                        if (Tweaks.DEBUG_EVENT_SERVICE) {
                            System.out.println(">>> callOnSuccess e=" + vMEvent2);
                        }
                        vMEvent2.callOnSuccess();
                        if (!Tweaks.DEBUG_EVENT_SERVICE) continue;
                        System.out.println(">>> callOnSuccess (after) e=" + vMEvent2);
                    }
                    catch (Throwable throwable3) {
                        this.logger().trace("Unhandled exception: %s", throwable3);
                    }
                }
            } else {
                for (VMEvent vMEvent2 : collection2) {
                    try {
                        if (Tweaks.DEBUG_EVENT_SERVICE) {
                            System.out.println(">>> callOnError e=" + vMEvent2);
                        }
                        vMEvent2.callOnError();
                    }
                    catch (Throwable throwable4) {
                        this.logger().trace("Unhandled exception: %s", throwable4);
                    }
                }
            }
            throw throwable;
        }
        for (VMEvent vMEvent3 : collection2) {
            try {
                if (!Tweaks.DEBUG_EVENT_SERVICE) continue;
                System.out.println(">>> succeed=" + bl + ", e=" + vMEvent3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (bl) {
            for (VMEvent vMEvent3 : collection2) {
                try {
                    if (Tweaks.DEBUG_EVENT_SERVICE) {
                        System.out.println(">>> callOnSuccess e=" + vMEvent3);
                    }
                    vMEvent3.callOnSuccess();
                    if (!Tweaks.DEBUG_EVENT_SERVICE) continue;
                    System.out.println(">>> callOnSuccess (after) e=" + vMEvent3);
                }
                catch (Throwable throwable) {
                    this.logger().trace("Unhandled exception: %s", throwable);
                }
            }
        } else {
            for (VMEvent vMEvent3 : collection2) {
                try {
                    if (Tweaks.DEBUG_EVENT_SERVICE) {
                        System.out.println(">>> callOnError e=" + vMEvent3);
                    }
                    vMEvent3.callOnError();
                }
                catch (Throwable throwable) {
                    this.logger().trace("Unhandled exception: %s", throwable);
                }
            }
        }
    }

    public void sync() {
        this.logger().trace("syncing events to the cloud", new Object[0]);
        this.queue.sync();
    }

    public void postVMEventSynchronously(VMEvent vMEvent) {
        this.postWithRetries("unused", Collections.singleton(vMEvent));
    }

    private static /* synthetic */ Response lambda$postWithRetries$2(InterfaceConnectionManager interfaceConnectionManager, Collection collection) throws IOException {
        return interfaceConnectionManager.sendVMEventBatch(collection);
    }
}

