/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.jars.ClassPathToSource;
import com.azul.crs.client.jars.CountdownRunnable;
import com.azul.crs.client.jars.JarAccess;
import com.azul.crs.client.jars.JarAccessFactory;
import com.azul.crs.client.jars.JarSource;
import com.azul.crs.client.jars.SourceCache;
import com.azul.crs.client.jars.VMEventHelper;
import com.azul.crs.client.jars.VmJarInfoRequestSupport;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.JarDetailsRequestMonitor;
import com.azul.crs.client.service.MonitorService;
import com.azul.crs.client.service.TempFilesMonitor;
import com.azul.crs.client.util.LRU;
import com.azul.crs.client.util.LRUCache;
import com.azul.crs.client.util.MyAtomicLongDebuggable;
import com.azul.crs.client.util.MySetDebuggable;
import com.azul.crs.client.util.Utils;
import com.azul.crs.client.util.async.AsyncPipeline;
import com.azul.crs.client.util.async.AsyncResourceHandler;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.jar.JarFile;

public final class JarLoadService
extends MonitorService {
    private static final JarLoadService instance = new JarLoadService();
    private VmEventConsumer eventConsumer;
    private final AtomicBoolean started = new AtomicBoolean();
    private final ExecutorService executorService;
    private final BlockingQueue<Runnable> executorServiceQueue;
    private volatile Utils.Deadline deadline;
    private volatile boolean terminated = false;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final JarAccessFactory jarAccessFactory;
    private final TempFilesMonitor tempFilesMonitor;
    private final JarDetailsRequestMonitor jarDetailsRequestMonitor;
    private final SourceCache sourceCache;
    private final AtomicLong tasksInProgressCounter = new AtomicLong();
    private final AtomicLong tasksCompletedCounter = new AtomicLong();
    private final AtomicLong jarFilesCanceledDueToTempfsLimit = new AtomicLong();
    private final AtomicLong jarFilesCanceledTotal = new AtomicLong();
    private final AtomicLong unhandledExceptions = new AtomicLong();
    private final MySetDebuggable<JarAccess> eventsProcessingInProgress = new MySetDebuggable("eventsProcessingInProgress");
    private final MyAtomicLongDebuggable eventsSendingInProgress = new MyAtomicLongDebuggable("eventsSendingInProgress");

    private JarLoadService() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger.error("Failed to initialize SHA-256 MessageDigest: %s", noSuchAlgorithmException);
            this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }
        this.sourceCache = new SourceCache(Tweaks.jarCacheSize);
        this.jarAccessFactory = new JarAccessFactory(Tweaks.jarCacheSize, ZipTools.createDefault(), messageDigest);
        this.executorServiceQueue = new LinkedBlockingQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.executorServiceQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        }){

            @Override
            public Future<?> submit(Runnable runnable) {
                if (JarLoadService.this.executorServiceQueue.size() > Tweaks.jarLoadMonitorTaskQueueSize) {
                    throw new RuntimeException("TaskQueue size limit has been reached: " + Tweaks.jarLoadMonitorTaskQueueSize);
                }
                JarLoadService.this.tasksInProgressCounter.incrementAndGet();
                return super.submit(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        JarLoadService.this.unhandledExceptions.incrementAndGet();
                        JarLoadService.this.logger.error("Exception while processing JarLoadMonitor task: %s", throwable);
                    }
                    finally {
                        JarLoadService.this.tasksCompletedCounter.incrementAndGet();
                        JarLoadService.this.tasksInProgressCounter.decrementAndGet();
                    }
                });
            }
        };
        this.jarDetailsRequestMonitor = new JarDetailsRequestMonitor();
        this.tempFilesMonitor = new TempFilesMonitor();
    }

    @Override
    public void start() {
        this.logger.trace("start", new Object[0]);
        this.tempFilesMonitor.start();
        this.jarDetailsRequestMonitor.start();
        this.reportClassPathJars();
        this.terminated = false;
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.logger.trace("stop started, deadline=%s", deadline);
        int n = 0;
        boolean bl = false;
        do {
            long l = this.eventsProcessingInProgress.size();
            long l2 = this.tasksInProgressCounter.get();
            long l3 = this.tasksCompletedCounter.get();
            boolean bl2 = this.jarDetailsRequestMonitor.expectingRequests();
            boolean bl3 = this.tempFilesMonitor.expectingRequests();
            long l4 = this.eventsSendingInProgress.get();
            bl = !Utils.Deadline.hasExpired(deadline) && (l > 0L || l2 > 0L || l4 > 0L || bl2 || bl3);
            try {
                if (this.terminated) {
                    this.logger.trace("cancel => break from stop method loop", new Object[0]);
                    break;
                }
                if (0 == (n = (n + 1) % 500) || !bl) {
                    this.logger.trace("stop in progress: deadline=%d, eventsProcessingInProgress=%d,  tasksInProgressCounter=%d, eventsSendingInProgress=%d, tasksCompletedCounter=%d, expectingDetails=%s:%s", deadline.remainder(TimeUnit.MILLISECONDS), l, l2, l4, l3, bl2, bl3);
                }
                if (!bl) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        } while (bl);
        this.jarDetailsRequestMonitor.stop(deadline);
        this.tempFilesMonitor.stop(deadline);
        this.executorService.shutdownNow();
        this.logger.trace("stop finished, exiting, deadline=%s, unhandledExceptions=%d", deadline, this.unhandledExceptions.get());
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("unfinished work: ", new Object[0]);
            this.jarDetailsRequestMonitor.stop(deadline);
            this.tempFilesMonitor.stop(deadline);
            this.eventsSendingInProgress.dump();
            this.eventsProcessingInProgress.dump();
            AsyncResourceHandler.dump();
            LRU.dump();
            LRUCache.dump();
            this.logger.debug("canceled jars due to tempfs limit: %d", this.jarFilesCanceledDueToTempfsLimit.get());
            this.logger.debug("canceled jars in total: %d", this.jarFilesCanceledTotal.get());
        }
    }

    public static JarLoadService getInstance(VmEventConsumer vmEventConsumer) {
        JarLoadService.instance.eventConsumer = vmEventConsumer;
        return instance;
    }

    private void postEvent(VMEvent vMEvent) {
        this.eventsSendingInProgress.incrementAndGet(vMEvent);
        vMEvent.onSuccessAppend(runnable -> () -> {
            try {
                if (runnable != null) {
                    runnable.run();
                }
            }
            finally {
                this.eventsSendingInProgress.decrementAndGet(vMEvent);
            }
        }).onErrorAppend(runnable -> () -> {
            try {
                if (runnable != null) {
                    runnable.run();
                }
            }
            finally {
                this.eventsSendingInProgress.decrementAndGet(vMEvent);
            }
        });
        try {
            VMEventHelper.postVMJarLoadedEvent(this.eventConsumer, vMEvent);
        }
        catch (Throwable throwable) {
            this.eventsSendingInProgress.decrementAndGet(vMEvent);
            this.logger.trace("failed to post VMEvent: %s", throwable);
            vMEvent.callOnError();
        }
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile) {
        block5: {
            if (!Options.notifyJarLoad.isYes()) {
                return;
            }
            if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CALLBACK) {
                return;
            }
            try {
                this.logger.trace("notifyJarLoad: url(%s), jar(%s)", uRL, Utils.toStringWithIdentityHash(jarFile));
                JarSource jarSource = new JarSource.Builder().fromUrl(uRL).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for url=%s and jar=%s ... %s", uRL, jarFile, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, jarFile)));
                }
            }
            catch (Throwable throwable) {
                System.err.println("error: unexpected exception in CRS: " + throwable);
                if (!Tweaks.DEBUG_JARLOAD) break block5;
                throwable.printStackTrace();
            }
        }
    }

    public void notifyJarLoad(URL uRL) {
        block5: {
            if (!Options.notifyJarLoad.isYes()) {
                return;
            }
            if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CALLBACK) {
                return;
            }
            try {
                this.logger.trace("notifyJarLoad: url(%s)", uRL);
                JarSource jarSource = new JarSource.Builder().fromUrl(uRL).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for url=%s ... %s", uRL, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, JarAccess.InitiatedBy.CLASS_LOADING)));
                }
            }
            catch (Throwable throwable) {
                System.err.println("error: unexpected exception in CRS: " + throwable);
                if (!Tweaks.DEBUG_JARLOAD) break block5;
                throwable.printStackTrace();
            }
        }
    }

    private void notifyClassPathEntryOrSourceSeen(String string, JarAccess.InitiatedBy initiatedBy) {
        block4: {
            if (!Options.notifyJarLoad.isYes()) {
                return;
            }
            try {
                this.logger.trace("notifyClassPathEntryOrSourceSeen: source(%s), initiatedBy(%s)", new Object[]{string, initiatedBy});
                JarSource jarSource = new JarSource.Builder().fromSource(string).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for source=%s ... %s", string, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, initiatedBy)));
                }
            }
            catch (Throwable throwable) {
                System.err.println("error: unexpected exception in CRS: " + throwable);
                if (!Tweaks.DEBUG_JARLOAD) break block4;
                throwable.printStackTrace();
            }
        }
    }

    public void notifyClassSourceSeen(String string) {
        if (!Options.notifyJarLoad.isYes()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_BY_CLASSLOAD) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(string, JarAccess.InitiatedBy.CLASS_LOADING);
    }

    public void notifyClassPathEntrySeen(String string) {
        if (!Options.notifyJarLoad.isYes()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CLASS_PATH) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(string, JarAccess.InitiatedBy.CLASS_PATH_ENTRY);
    }

    public void notifyClassPathEntryByManifestSeen(String string) {
        if (!Options.notifyJarLoad.isYes()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CLASS_PATH) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(string, JarAccess.InitiatedBy.CLASS_PATH_ENTRY_BY_MANIFEST);
    }

    @Override
    public void cancel() {
        this.terminated = true;
    }

    private void postJarError(JarAccess jarAccess, VMEventHelper.JarLoadProcessingError jarLoadProcessingError, Exception exception) {
        if (jarLoadProcessingError == VMEventHelper.JarLoadProcessingError.TEMPFS_LIMIT) {
            this.jarFilesCanceledDueToTempfsLimit.incrementAndGet();
        }
        VMEvent vMEvent = VMEventHelper.jarLoadEventWithError(null, jarAccess, jarLoadProcessingError, exception);
        this.postEvent(vMEvent);
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> allocateTempFile(AsyncPipeline<JarAccess> asyncPipeline) {
        return asyncResourceHandler -> {
            JarAccess jarAccess = (JarAccess)asyncResourceHandler.getObject();
            jarAccess.getCache().addDebugInfo(JarAccess.Cache.DebugInfo.BEFORE_TEMP_ALLOCATION);
            this.logger.trace("requesting temp file for jarAccess=%s; holder=%s", jarAccess, asyncResourceHandler);
            if (((JarAccess)asyncResourceHandler.getObject()).requiredTempfsSpaceWithParents() > 1024L * Options.maxJarFileCacheSize.getLong()) {
                this.logger.trace("temp file allocation failure for jarAccess=%s, => not enough space (%s[Kb] limit); holder=%s", jarAccess, Options.maxJarFileCacheSize.getLong(), asyncResourceHandler);
                jarAccess.getCache().addDebugInfo(JarAccess.Cache.DebugInfo.ON_NOT_ENOUGH_TEMPFS_LIMIT);
                InsufficientTempfsLimit insufficientTempfsLimit = new InsufficientTempfsLimit(((JarAccess)asyncResourceHandler.getObject()).requiredTempfsSpace(), ((JarAccess)asyncResourceHandler.getObject()).requiredTempfsSpaceWithParents(), asyncResourceHandler);
                this.postJarError((JarAccess)asyncResourceHandler.getObject(), VMEventHelper.JarLoadProcessingError.TEMPFS_LIMIT, insufficientTempfsLimit);
                asyncResourceHandler.cancel(insufficientTempfsLimit);
                return null;
            }
            this.tempFilesMonitor.waitFor(this.executorService, ((JarAccess)asyncResourceHandler.getObject()).requiredTempfsSpace(), tempFile -> {
                this.logger.trace("temp file allocated jarAccess=%s, tempFile=%s; holder=%s", jarAccess, tempFile, asyncResourceHandler);
                if (tempFile != null) {
                    jarAccess.getCache().addDebugInfo(JarAccess.Cache.DebugInfo.TEMPFILE_ALLOCATED);
                    asyncResourceHandler.finalizer = () -> {
                        jarAccess.getCache().addDebugInfo(JarAccess.Cache.DebugInfo.TEMPFILE_IS_DELETING);
                        this.logger.trace("[allocateTempFile$finalizer] deleting temp file[%s] associated with jarAccess=%s; holder=%s", tempFile, jarAccess, asyncResourceHandler);
                        tempFile.delete();
                    };
                } else {
                    this.logger.trace("temp file is not required for jarAccess=%s; holder=%s", jarAccess, asyncResourceHandler);
                    jarAccess.getCache().addDebugInfo(JarAccess.Cache.DebugInfo.TEMPFILE_IS_NOT_REQUIRED);
                }
                try {
                    jarAccess.acquireResources((TempFilesFactory.TempFile)tempFile);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                asyncResourceHandler.next().accept(jarAccess);
            });
            return asyncResourceHandler.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportClassPathEntriesByManifest(AsyncPipeline<JarAccess> asyncPipeline) {
        return asyncResourceHandler -> {
            ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.BEFORE_REPORT_CLASS_PATH_ATTRIBUTE);
            this.logger.trace("reporting jars initiated by class-path properties from manifest file for jarAccess=%s; holder=%s", asyncResourceHandler, asyncResourceHandler.getObject(), asyncResourceHandler);
            ((JarAccess)asyncResourceHandler.getObject()).forEachManifestClassPathEntry(string -> this.notifyClassPathEntryByManifestSeen((String)string));
            asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
            return asyncResourceHandler.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportMinimalEventAndWaitDetails(AsyncPipeline<JarAccess> asyncPipeline) {
        return asyncResourceHandler3 -> {
            ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.BEFORE_REPORT_MINIMAL_EVENT);
            PerformanceMetrics.logJarLoadEventReported();
            asyncResourceHandler3.finalizer = () -> {
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.MINIMAL_EVENT_FINALIZER);
                PerformanceMetrics.logJarLoadEventConfirmed();
            };
            CountdownRunnable countdownRunnable = new CountdownRunnable(2, asyncResourceHandler2 -> {
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.MINIMAL_EVENT_ON_COUNTDOWN);
                asyncResourceHandler2.next().accept(asyncResourceHandler2.getObject());
            }, (asyncResourceHandler, runtimeException) -> asyncResourceHandler.next().cancel((Exception)runtimeException));
            VMEvent vMEvent = VMEventHelper.prepareMinimalEvent((JarAccess)asyncResourceHandler3.getObject());
            vMEvent.onSuccess(() -> {
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.MINIMAL_EVENT_SENT_SUCCESSFULLY);
                this.logger.trace("(check if called) onSuccess: %s; holder=%s", asyncResourceHandler3.getObject(), asyncResourceHandler3);
                countdownRunnable.runOrDecrement((AsyncResourceHandler)asyncResourceHandler3);
            });
            vMEvent.onError(() -> {
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.MINIMAL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR);
                this.jarDetailsRequestMonitor.cancel((JarAccess)asyncResourceHandler3.getObject());
                countdownRunnable.cancel((AsyncResourceHandler)asyncResourceHandler3, new RuntimeException("event for " + asyncResourceHandler3.getObject() + " was not sent."));
            });
            this.jarDetailsRequestMonitor.waitFor(this.executorService, (JarAccess)asyncResourceHandler3.getObject(), (detailsLevel, exception) -> {
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.JAR_DETAILS_RECEIVED);
                this.logger.trace("(on response) jarAccess=%s, detailsLevel=%s, cause=%s; holder=%s", asyncResourceHandler3.getObject(), detailsLevel, exception, asyncResourceHandler3);
                if (exception != null) {
                    countdownRunnable.cancel((AsyncResourceHandler)asyncResourceHandler3, new RuntimeException("wrap: ", (Throwable)exception));
                    return;
                }
                if (detailsLevel == VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel.NONE) {
                    ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.JAR_DETAILS_NONE);
                    asyncResourceHandler3.finalize();
                    return;
                }
                assert (detailsLevel == VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel.ALL_HASHES);
                ((JarAccess)asyncResourceHandler3.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.JAR_DETAILS_ALL_HASHES);
                countdownRunnable.runOrDecrement((AsyncResourceHandler)asyncResourceHandler3);
            });
            this.postEvent(vMEvent);
            return asyncResourceHandler3.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportAllNestedJars(AsyncPipeline<JarAccess> asyncPipeline) {
        return asyncResourceHandler -> {
            ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.BEFORE_REPORTING_NESTED);
            JarAccess jarAccess2 = (JarAccess)asyncResourceHandler.getObject();
            this.logger.trace("report nested jars: jarAccess=%s; holder=%s", jarAccess2, asyncResourceHandler);
            ArrayList arrayList = new ArrayList();
            jarAccess2.forEachJarEntry(jarAccess -> arrayList.add(jarAccess));
            this.logger.trace("report nested jars: jarAccess=%s, children-N=%d; holder=%s", jarAccess2, arrayList.size(), asyncResourceHandler);
            VMEventHelper.prepareMinimalEvent(jarAccess2);
            int n = Tweaks.forceFullJarLoadedEvents && !Tweaks.keepNestedToParentOrderOnForceFull ? 1 : 1 + arrayList.size();
            CountdownRunnable countdownRunnable = new CountdownRunnable(n, object -> {
                ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.ALL_NESTED_REPORTED);
                asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
            }, (object, object2) -> {
                ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.NESTED_JAR_REPORTING_ERROR);
                this.postJarError(jarAccess2, VMEventHelper.JarLoadProcessingError.NESTED_JAR, (Exception)object2);
                asyncResourceHandler.cancel((Exception)object2);
            });
            countdownRunnable.runOrDecrement(null);
            for (JarAccess jarAccess3 : arrayList) {
                this.logger.trace("report nested entry (parent:%s)->(nested:%s); holder=%s", jarAccess2, jarAccess3, asyncResourceHandler);
                this.processJarLoad(AsyncPipeline.first(() -> jarAccess3).next(asyncPipeline -> asyncResourceHandler -> {
                    asyncResourceHandler.finalizer = () -> countdownRunnable.runOrDecrement(jarAccess3);
                    asyncResourceHandler.errorHandler = exception -> countdownRunnable.cancel(asyncResourceHandler.getObject(), new RuntimeException("nested jar processing exception", (Throwable)exception));
                    asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
                    return asyncResourceHandler.next();
                }));
            }
            return asyncResourceHandler.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportFullEvent(AsyncPipeline<JarAccess> asyncPipeline) {
        return asyncResourceHandler -> {
            ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.BEFORE_REPORT_FULL_EVENT);
            JarAccess jarAccess = (JarAccess)asyncResourceHandler.getObject();
            this.logger.trace("postFull after all children, jarAccess=%s; holder=%s", jarAccess, asyncResourceHandler);
            VMEventHelper.prepareDetailed(jarAccess.getCache().vmEvent, jarAccess);
            jarAccess.getCache().vmEvent.onSuccess(() -> {
                ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.FULL_EVENT_SENT_SUCCESFULLY);
                asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
            }).onError(() -> ((JarAccess)asyncResourceHandler.getObject()).getCache().addDebugInfo(JarAccess.Cache.DebugInfo.FULL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR));
            this.postEvent(jarAccess.getCache().vmEvent);
            return asyncResourceHandler.next();
        };
    }

    public void processJarLoad(AsyncPipeline<JarAccess> asyncPipeline) {
        if (Tweaks.forceFullJarLoadedEvents) {
            asyncPipeline.next(AsyncPipeline::notNull).step(asyncResourceHandler -> {
                asyncResourceHandler.errorHandler = exception -> this.jarFilesCanceledTotal.incrementAndGet();
            }).step(asyncResourceHandler -> {
                asyncResourceHandler.finalizer = () -> {
                    if (!Tweaks.DEBUG_JARLOAD) {
                        return;
                    }
                    JarAccess.Cache.DebugInfo debugInfo = ((JarAccess)asyncResourceHandler.getObject()).getCache().lastDebugInfo;
                    if (debugInfo != JarAccess.Cache.DebugInfo.FULL_EVENT_SENT_SUCCESFULLY) {
                        this.logger.error("Unexpected state after processing jarAccess=(%s); holder=%s", Utils.toStringWithIdentityHash(asyncResourceHandler.getObject()), asyncResourceHandler);
                    }
                };
            }).step(asyncResourceHandler -> {
                asyncResourceHandler.finalizer = () -> this.eventsProcessingInProgress.remove((JarAccess)asyncResourceHandler.getObject());
                this.eventsProcessingInProgress.add((JarAccess)asyncResourceHandler.getObject());
            }).next(this::allocateTempFile).next(this::reportClassPathEntriesByManifest).next(this::reportAllNestedJars).next(this::reportFullEvent).start(this.executorService);
            return;
        }
        asyncPipeline.next(AsyncPipeline::notNull).step(asyncResourceHandler -> {
            asyncResourceHandler.errorHandler = exception -> this.jarFilesCanceledTotal.incrementAndGet();
        }).step(asyncResourceHandler -> {
            asyncResourceHandler.finalizer = () -> {
                if (!Tweaks.DEBUG_JARLOAD) {
                    return;
                }
                JarAccess.Cache.DebugInfo debugInfo = ((JarAccess)asyncResourceHandler.getObject()).getCache().lastDebugInfo;
                if (debugInfo != JarAccess.Cache.DebugInfo.JAR_DETAILS_NONE && debugInfo != JarAccess.Cache.DebugInfo.FULL_EVENT_SENT_SUCCESFULLY) {
                    this.logger.error("Unexpected state after processing jarAccess=(%s); holder=%s", Utils.toStringWithIdentityHash(asyncResourceHandler.getObject()), asyncResourceHandler);
                }
            };
        }).step(asyncResourceHandler -> {
            asyncResourceHandler.finalizer = () -> this.eventsProcessingInProgress.remove((JarAccess)asyncResourceHandler.getObject());
            this.eventsProcessingInProgress.add((JarAccess)asyncResourceHandler.getObject());
        }).next(this::allocateTempFile).next(this::reportClassPathEntriesByManifest).next(this::reportMinimalEventAndWaitDetails).step(asyncResourceHandler -> {
            if (!Tweaks.postponeExitUntilNoUnconfirmedJars) {
                this.eventsProcessingInProgress.remove((JarAccess)asyncResourceHandler.getObject());
            }
        }).next(this::reportAllNestedJars).next(this::reportFullEvent).start(this.executorService);
    }

    private void reportClassPathJars(Collection<String> collection) {
        for (String string : collection) {
            try {
                this.notifyClassPathEntrySeen(string);
            }
            catch (Exception exception) {
                this.logger.warning("unexpected problem handling ClassPath entry %s: %s", string, exception);
            }
        }
    }

    private void reportClassPathJars() {
        this.reportClassPathJars(JarLoadService.getClassPathJarList());
    }

    private static List<String> getClassPathJarList() {
        return ClassPathToSource.process(System.getProperty("java.class.path"));
    }

    private static class InsufficientTempfsLimit
    extends RuntimeException {
        public InsufficientTempfsLimit(long l, long l2, Object object) {
            super("File with size=" + l + "[bytes] (with parents=" + l2 + "[bytes]) is bigger than allowed tempfs consumption limit=" + Options.maxJarFileCacheSize.getLong() + "[Kb]; holder=" + object);
        }
    }
}

