/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Digest {
    private static final MessageDigest DIGEST = Digest.initDigest("SHA-256");
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();
    private static final int BLOCK_SIZE = 64;
    private final MessageDigest md;
    private final ByteBuffer mdbuffer = ByteBuffer.wrap(new byte[64]);

    private Digest(MessageDigest messageDigest) {
        this.md = messageDigest;
    }

    public static Digest get() {
        return new Digest(Digest.cloneDigest(DIGEST));
    }

    private static MessageDigest initDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger(Digest.class.getName()).log(Level.SEVERE, null, noSuchAlgorithmException);
            System.exit(0);
            return null;
        }
    }

    private static MessageDigest cloneDigest(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(Digest.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
            System.exit(0);
            return null;
        }
    }

    private void update(byte[] byArray, int n, int n2) {
        int n3 = this.mdbuffer.remaining();
        if (n2 > n3) {
            this.mdbuffer.put(byArray, n, n3);
            this.md.update(this.mdbuffer.array(), 0, 64);
            n += n3;
            n2 -= n3;
            this.mdbuffer.rewind();
        }
        while (n2 >= 64) {
            this.md.update(byArray, n, 64);
            n += 64;
            n2 -= 64;
        }
        if (n2 > 0) {
            this.mdbuffer.put(byArray, n, n2);
        }
    }

    private void flushMDBuffer() {
        int n = this.mdbuffer.position();
        if (n > 0) {
            this.md.update(this.mdbuffer.array(), 0, n);
            this.mdbuffer.rewind();
        }
    }

    void update(ByteBuffer byteBuffer) {
        this.update(byteBuffer.array(), 0, byteBuffer.position());
    }

    void update(short s) {
        if (this.mdbuffer.remaining() < 2) {
            this.flushMDBuffer();
        }
        this.mdbuffer.put((byte)(s & 0xFF));
        this.mdbuffer.put((byte)(s >> 8 & 0xFF));
    }

    void update(String string) {
        this.update(string.getBytes(), 0, string.length());
    }

    private static String encode(byte[] byArray) {
        int n = byArray.length << 1;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n3];
            cArray[n2++] = DIGITS[by >> 4 & 0xF];
            cArray[n2++] = DIGITS[by & 0xF];
            ++n3;
        }
        return new String(cArray);
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    public String asHexString() {
        this.flushMDBuffer();
        return Digest.encode(this.md.digest());
    }
}

