/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedWithDataPayloadAVR;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import packetprocessor.AVR_MCU8_PacketProcessorWithDataPayloadUART;
import protocol.nextchunkgetter.GetNextFlashData;
import readFileModel.MemoryModel;

public class CommandWriteDeviceFlashUART_AVR
extends ACommandBaseExtendedWithDataPayloadAVR {
    private static final int CMD_LENGTH = 11;
    private static final int READ_CMD_LENGTH = 10;
    private static final int SYNCH_BYTE_POS = 0;
    private static final int SYNCH_CHARACTER = 85;
    private static final int CMD_BYTE_POS = 1;
    private static final int WRITE_CMD = 2;

    public CommandWriteDeviceFlashUART_AVR(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataAVR();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)2;
        this.model.length = deviceMemoryModel.byteAlignedWriteBlockSize;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 11 + deviceMemoryModel.byteAlignedWriteBlockSize;
        this.model.readLengthExpected = 11;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    protected void setEraseChunckIterator() {
        this.addressIterator = new GetNextFlashData(this.deviceMemoryModel);
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "No Synch Byte before Response");
            throw new ValidationException("Malformed: No Synch Byte");
        }
        if (this.model.dataRead[1] != 2) {
            LOGGER.log(Level.SEVERE, "Bootloader Write Command INCORRECT");
            throw new ValidationException("Malformed: Format not correct");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new AVR_MCU8_PacketProcessorWithDataPayloadUART();
    }
}

