/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseI2CExtendedWithDataPayload;
import i2cBootloaderModel.CommandModelWrite;
import java.util.logging.Level;
import packetprocessor.PacketProcessorWithDataPayload;
import protocol.nextchunkgetter.GetNextFlashData;
import readFileModel.MemoryModel;

public class CommandWriteDeviceFlash_AVR
extends ACommandBaseI2CExtendedWithDataPayload {
    private static final int CMD_LENGTH = 9;
    private static final int CMD_BYTE_POS = 0;
    private static final byte WRITE_CMD = 2;
    private static final int CMD_OUT_OF_RANGE_RESPONSE = 254;
    private static final int CMD_NOT_SUPPORTED_RESPONSE = 253;
    private static final int CMD_SUCCESS_RESPONSE = 1;
    private static final int STATUS_BYTE_POS = 9;

    public CommandWriteDeviceFlash_AVR(I2CSoftwareLibraryCommunicationsInterface commsInterface, MemoryModel deviceMemoryModel) {
        this.i2cInterface = commsInterface;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadData();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)2;
        this.model.length = deviceMemoryModel.byteAlignedWriteBlockSize;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 9 + deviceMemoryModel.byteAlignedWriteBlockSize;
        this.model.readLengthExpected = 10;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    protected void setEraseChunckIterator() {
        this.addressIterator = new GetNextFlashData(this.deviceMemoryModel);
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead.length != this.model.readLengthExpected) {
            LOGGER.log(Level.SEVERE, "Bootloader Write Response should be 10 bytes");
            throw new ValidationException("Bootloader Write Response wrong size");
        }
        if (this.model.dataRead[0] != 2) {
            LOGGER.log(Level.SEVERE, "Bootloader Write Command INCORRECT");
            throw new ValidationException("Malformed: Format Incorrect");
        }
        switch (this.model.dataRead[9]) {
            case 1: {
                LOGGER.log(Level.SEVERE, "Bootloader Write Response Successful.");
                break;
            }
            case 254: {
                LOGGER.log(Level.SEVERE, "Bootloader Write Responded Out-Of-Range.");
                throw new ValidationException("Bootloader Erase Responded Out-Of-Range.");
            }
            case 253: {
                LOGGER.log(Level.SEVERE, "Bootloader Write Command NOT SUPPORTED.");
                throw new ValidationException("Bootloader Erase Command NOT SUPPORTED.");
            }
            default: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Command Unspecific failure.");
                throw new ValidationException("Bootloader Erase Unspecific failure.");
            }
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorWithDataPayload();
    }
}

