/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController.avr;

import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderController.mcu8.ACommandBaseI2CExtendedNoDataPayload;
import i2cBootloaderModel.CommandModelWrite;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import readFileModel.MemoryModel;

public class CommandReadVersionProtocolUSB_AVR
extends ACommandBaseI2CExtendedNoDataPayload {
    private final int READ_VER_CMD_SIZE = 24;
    private static final int CMD_LENGTH = 9;
    private static final int CMD_BYTE_POS = 0;
    private static final int READ_VERSION_CMD = 0;
    private static final Logger LOGGER = Logger.getLogger(CommandReadVersionProtocolUSB_AVR.class.getName());

    public CommandReadVersionProtocolUSB_AVR(I2CSoftwareLibraryCommunicationsInterface commsInterface, MemoryModel deviceMemoryModel) {
        this.i2cInterface = commsInterface;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadData();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = 0;
        this.model.length = 0L;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 9;
        this.model.readLengthExpected = this.model.writeLength + 24;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int process() throws TransactionFailureException {
        super.process();
        this.modelBootloader.setVersion(new String(this.model.dataRead, Charset.forName("ISO-8859-1")));
        return 0;
    }

    @Override
    public int validateLevel2() throws ValidationException {
        int modelIndex = 0;
        if (this.model.dataRead.length != this.model.readLengthExpected) {
            LOGGER.log(Level.SEVERE, "Bootloader Version Response should be {0} bytes", this.model.readLengthExpected);
            throw new ValidationException("Bootloader Version Response wrong size");
        }
        for (modelIndex = 0; modelIndex < 9; ++modelIndex) {
            if (this.model.dataRead[modelIndex] == 0) continue;
            LOGGER.log(Level.SEVERE, "Bootloader Version Command Echo BAD");
            throw new ValidationException("Command Echo BAD");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }
}

