/*
 * Decompiled with CFR 0.152.
 */
package protocol.nextchunkgetter;

import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;
import readFileModel.MCU32MemoryModel;

public class GetNextHexLine
implements IGetNextChunk {
    private MCU32MemoryModel deviceMemoryModel;
    private int cursor = 0;
    protected State memoryState = State.BUSY;
    DataChunk line = new DataChunk();

    public void setMemoryModel(MCU32MemoryModel deviceMemoryModel) {
        this.deviceMemoryModel = deviceMemoryModel;
    }

    @Override
    public DataChunk getData() {
        switch (this.memoryState) {
            case BUSY: {
                this.line.address = 0;
                this.line.noData = false;
                byte[] data = this.deviceMemoryModel.hexFile.get(this.cursor);
                if (data != null) {
                    this.line.data = this.deviceMemoryModel.hexFile.get(this.cursor);
                    this.line.length = this.deviceMemoryModel.hexFile.get(this.cursor).length;
                    ++this.cursor;
                    break;
                }
                this.memoryState = State.DONE;
                break;
            }
            case DONE: {
                this.line = null;
                this.cursor = 0;
                this.memoryState = State.BUSY;
            }
        }
        return this.line;
    }

    protected static enum State {
        BUSY,
        DONE;

    }
}

