/*
 * Decompiled with CFR 0.152.
 */
package readFileController;

import i2cBootloaderModel.DeviceArchitecture;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;

public class TextFileIO
implements IFileIO {
    private MCU32MemoryModel deviceMemoryModel;
    private static final Logger LOGGER = Logger.getLogger(TextFileIO.class.getName());

    @Override
    public void setMemoryModel(Object whatModel) {
        this.deviceMemoryModel = (MCU32MemoryModel)whatModel;
    }

    @Override
    public void setDeviceArchitecture(DeviceArchitecture whichFamily) {
    }

    @Override
    public File fopen(String fileName) {
        File fp = new File(fileName);
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fread(File fp) {
        BufferedReader hexFile = null;
        try {
            String str;
            hexFile = new BufferedReader(new FileReader(fp));
            int iterator = 0;
            while ((str = hexFile.readLine()) != null) {
                byte[] data = str.getBytes();
                ArrayList<Byte> out = new ArrayList<Byte>();
                for (int i = 1; i < data.length; ++i) {
                    byte tmp = 0;
                    tmp = data[i] < 65 ? (byte)(data[i] - 48) : (byte)((data[i] & 0xF) + 9);
                    tmp = (byte)(tmp << 4);
                    if (++i >= data.length) {
                        out.add(tmp);
                        break;
                    }
                    tmp = data[i] < 65 ? (byte)(tmp | (byte)(data[i] - 48)) : (byte)(tmp | (byte)((data[i] & 0xF) + 9));
                    if (tmp == this.deviceMemoryModel.SOF || tmp == this.deviceMemoryModel.EOT || tmp == this.deviceMemoryModel.COMMAND || tmp == this.deviceMemoryModel.DLE) {
                        out.add((byte)16);
                    }
                    out.add(tmp);
                }
                byte[] dataTemp = new byte[out.size()];
                for (int i = 0; i < out.size(); ++i) {
                    dataTemp[i] = (Byte)out.get(i);
                }
                this.deviceMemoryModel.hexFile.put(iterator, dataTemp);
                ++iterator;
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "File not found: " + ex.toString(), ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IO Exception: " + ex.toString(), ex);
        }
        finally {
            try {
                hexFile.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "IO Exception: " + ex.toString(), ex);
            }
        }
    }
}

