/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBase;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandEraseDeviceUART;
import i2cBootloaderController.CommandWriteDeviceConfigUART;
import i2cBootloaderController.CommandWriteDeviceEEUART;
import i2cBootloaderController.CommandWriteDeviceFlashUART;
import i2cBootloaderController.avr.CommandReadVersionProtocolUART;
import i2cBootloaderController.mcu8.CommandChecksumUART;
import i2cBootloaderController.mcu8.CommandResetDeviceUART;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import observers.ABootloaderObserver;
import readFileController.HexFileIO;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.model.UBootModel;

public class BootloadDFUFED
extends ACommand<UBootModel> {
    private static final int retryAttempts = 1;
    private static final int genericTimeout = 1000;
    private static final int eraseTimeout = 20000;
    protected String fileName;
    protected ACommandBase readVersionCommand;
    protected ACommandBase eraseDeviceCommand;
    protected ACommandBase checksumCommand;
    protected ACommandBase resetCommand;
    protected ACommandBase writeCommand;
    protected ACommandBase writeCommandEE;
    protected ACommandBase writeCommandConfig;
    IFileIO fileReader = new HexFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC18);
    protected BootloaderModel model = new BootloaderModel();
    private static final Logger LOGGER = Logger.getLogger(BootloadDFUFED.class.getName());

    public BootloadDFUFED() {
        this.retryCount = 1;
        this.timeout = 1000;
    }

    public void createCommands() {
        this.readVersionCommand = new CommandReadVersionProtocolUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.readVersionCommand, 1, 1000);
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDeviceUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.checksumCommand = new CommandChecksumUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.resetCommand = new CommandResetDeviceUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlashUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommandEE = new CommandWriteDeviceEEUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommandConfig = new CommandWriteDeviceConfigUART(((UBootModel)this.device).getInputStream(), ((UBootModel)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 1, 20000);
        this.initializeCommands(this.checksumCommand, 1, 1000);
        this.initializeCommands(this.resetCommand, 1, 1000);
        this.initializeCommands(this.writeCommand, 1, 1000);
        this.initializeCommands(this.writeCommandConfig, 1, 1000);
        this.initializeCommands(this.writeCommandEE, 1, 1000);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBase command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootModel)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started"));
        LOGGER.log(Level.FINE, String.format("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started", new Object[0]));
        this.deviceMemoryModel = ((UBootModel)this.device).ubootPojo.getDeviceArchitecture().compareTo("PIC16") == 0 ? new MemoryModel(DeviceArchitecture.PIC16) : new MemoryModel(DeviceArchitecture.PIC18);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootModel)this.device).ubootPojo.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), true, Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                int pageSize;
                assert (whatChanged.equals("Version"));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                int deviceID = changedBytes[17] << 8 & 0xFFFF | changedBytes[16] & 0xFF;
                int eraseSize = pageSize = changedBytes[21] << 8 & 0xFFFF | changedBytes[20] & 0xFF;
                int writeSize = pageSize;
                String fs = "%s)        BLD_VER: %s          Device ID: 0x%02X           FL_ER: %d           FL_WR: %d           User ID: 0x%04X";
                String version = String.format(fs, ((UBootModel)BootloadDFUFED.this.device).getDeviceName(), changedBytes[10], deviceID, eraseSize, writeSize, changedBytes[25] << 24 & 0xFFFFFFFF | changedBytes[24] << 16 & 0xFFFFFF | changedBytes[23] << 8 & 0xFFFF | changedBytes[22] & 0xFF);
                ((UBootModel)BootloadDFUFED.this.device).setVersion(version);
                LOGGER.log(Level.FINE, String.format("%s: %s%n", whatChanged, version));
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootModel)BootloadDFUFED.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(this.deviceMemoryModel);
        this.fileName = ((UBootModel)this.device).ubootPojo.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Hex File is Invalid");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootModel)this.device).setConsoleText(this.timeStamp("Hex File (re)loaded..."));
        LOGGER.log(Level.FINE, this.timeStamp("Hex File (re)loaded ..."));
        try {
            boolean dividesOdd;
            ((UBootModel)this.device).setConsoleText(this.timeStamp("(20) Sec Timeout Check per CMD"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Reading Version ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Reading Version ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Communication with Device"));
            this.readVersionCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Bootloader Version Read Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Bootloader Version Read Successful"));
            if (this.deviceMemoryModel.deviceFamily.equals((Object)DeviceArchitecture.PIC16)) {
                String parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
                Integer convertedEraseValue = Integer.parseInt(parsedEraseSize.replace("0x", ""), 16);
                String parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
                Integer convertedWriteValue = Integer.parseInt(parsedWriteSize.replace("0x", ""), 16);
                ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
                convertedWriteValue = convertedWriteValue * 2;
                this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
                ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
                convertedEraseValue = convertedEraseValue * 2;
                this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
            } else {
                ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize("0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_ER") + 7, ((UBootModel)this.device).getVersion().indexOf("FL_WR") - 11).toString())));
                this.deviceMemoryModel.setbyteAlignedEraseRowSize(Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16));
                ((UBootModel)this.device).ubootPojo.setWriteBlockSize("0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString())));
                this.deviceMemoryModel.setbyteAlignedWriteBlockSize(Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
            }
            boolean remainderExist = this.deviceMemoryModel.byteAlignedBootloaderOffset % this.deviceMemoryModel.byteAlignedWriteBlockSize == 1;
            Integer checkNumber = this.deviceMemoryModel.byteAlignedBootloaderOffset / this.deviceMemoryModel.byteAlignedWriteBlockSize;
            if (this.deviceMemoryModel.deviceFamily.equals((Object)DeviceArchitecture.PIC16)) {
                checkNumber = checkNumber / 2;
            }
            boolean bl = dividesOdd = (checkNumber & 1) != 0;
            if (remainderExist || dividesOdd) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("WARNING: Application Offset exist between ROWS/PAGE boundaries."));
                ((UBootModel)this.device).setConsoleText(this.timeStamp("WARNING: Application Bootload may fail."));
                LOGGER.log(Level.SEVERE, this.timeStamp("WARNING: Application Offset exist between ROWS/PAGE boundaries."));
                LOGGER.log(Level.SEVERE, this.timeStamp("WARNING: Application Bootload may fail."));
            }
            this.createAllExceptReadVersion();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Erasing Device ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Erasing Device ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Erase Range"));
            this.eraseDeviceCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Erase Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Erase Successful"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming Flash ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Programming Flash ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Hex Offset"));
            this.writeCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Flashed Programmed"));
            LOGGER.log(Level.FINE, this.timeStamp("Flashed Programmed"));
            if (((UBootModel)this.device).ubootPojo.getProgramEEData().compareTo("Enabled") == 0) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming EEData ..."));
                LOGGER.log(Level.FINE, this.timeStamp("Programming EEData ..."));
                this.writeCommandEE.executeChain();
                ((UBootModel)this.device).setConsoleText(this.timeStamp("EEData Programmed"));
                LOGGER.log(Level.FINE, this.timeStamp("EEData Programmed"));
            }
            if (((UBootModel)this.device).ubootPojo.getProgramConfigurationWords().compareTo("Enabled") == 0) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming Configuration Words ..."));
                LOGGER.log(Level.FINE, this.timeStamp("Programming Configuration Words ..."));
                this.writeCommandConfig.executeChain();
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Configuration Words Programmed"));
                LOGGER.log(Level.FINE, this.timeStamp("Configuration Words Programmed"));
            }
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Retrieving Checksum ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Retrieving Checksum ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Build Properties"));
            this.checksumCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Checksum Matched"));
            LOGGER.log(Level.FINE, this.timeStamp("Checksum Matched"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Resetting Device"));
            LOGGER.log(Level.FINE, this.timeStamp("Resetting Device"));
            this.resetCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Device Reset"));
            LOGGER.log(Level.FINE, this.timeStamp("Device Reset"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("FULL Bootloader SUCCESSFUL"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
        }
        catch (TransactionFailureException ex) {
            ((UBootModel)this.device).setConsoleText(this.timeStamp(ex.whatException));
            LOGGER.log(Level.SEVERE, "Chain Exception Thrown: " + ex.whatException, ex);
        }
    }

    @Override
    public void setDataModel(UBootModel model) {
        this.device = model;
    }

    @Override
    public UBootModel getDataModel() {
        return (UBootModel)this.device;
    }
}

