/*
 * Decompiled with CFR 0.152.
 */
package toplevel;

import com.microchip.core.util.IValidator;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.util.Duration;
import unified.bootloader.model.IDeviceModel;

public abstract class JavaFXTextFieldChangeListener<T extends IDeviceModel>
implements ChangeListener<String> {
    protected FadeTransition animation;
    protected static final int PULSE_MS = 500;
    protected TextField textField;
    protected T device;
    protected IValidator validator = null;

    public JavaFXTextFieldChangeListener(TextField textField, T device) {
        this.textField = textField;
        this.device = device;
        this.animate();
    }

    public void animate() {
        this.animation = new FadeTransition(Duration.millis((double)500.0), (Node)this.textField);
        this.animation.setFromValue(1.0);
        this.animation.setToValue(0.1);
        this.animation.setCycleCount(-1);
        this.animation.setAutoReverse(true);
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public abstract void changed(ObservableValue<? extends String> var1, String var2, String var3);
}

