/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import unified.bootloader16bit.BadResponseException;
import unified.bootloader16bit.Bootloader16AbstractFactory;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandFactory;
import unified.bootloader16bit.CommandFactoryImpl;
import unified.bootloader16bit.CommandStatusFactory;
import unified.bootloader16bit.CommandStatusFactoryImpl;
import unified.bootloader16bit.EventHandler;
import unified.bootloader16bit.EventHandlerImplNull;
import unified.bootloader16bit.FnAddressAccessor;
import unified.bootloader16bit.FnCommandAccessor;
import unified.bootloader16bit.FnDataLengthAccessor;
import unified.bootloader16bit.FnErasePageSizeAccessor;
import unified.bootloader16bit.FnMaxPacketSize;
import unified.bootloader16bit.FnMinWriteSizeAccessor;
import unified.bootloader16bit.FnProgramEndAddressAccessor;
import unified.bootloader16bit.FnProgramStartAddressAccessor;
import unified.bootloader16bit.FnPrototypeSizeVisitorImpl;
import unified.bootloader16bit.FnStatusAccessor;
import unified.bootloader16bit.IncompleteResetException;
import unified.bootloader16bit.InvalidAddressException;
import unified.bootloader16bit.ModelProxy;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.ProtocolInUseException;
import unified.bootloader16bit.Segment;
import unified.bootloader16bit.SegmentedImage;
import unified.bootloader16bit.SelfVerificationFailedException;
import unified.bootloader16bit.SelfVerificationNotSupportedException;
import unified.bootloader16bit.TimeoutException;
import unified.bootloader16bit.VerificationCommandProducer;
import unified.bootloader16bit.VerificationException;
import unified.bootloader16bit.WriteCommandProducer;
import unified.bootloader16bit.hexfile.InvalidRecordException;

public class BootProtocol {
    private final CommandFactory commandFactory = new CommandFactoryImpl();
    private final CommandStatusFactory commandStatusFactory = new CommandStatusFactoryImpl();
    private static final Integer RESPONSE_HEADER_SIZE = 11;
    private static final Integer RESPONSE_HEADER_WITH_STATUS_SIZE = RESPONSE_HEADER_SIZE + 1;
    private static final Integer GET_VERSION_RESPONSE_LENGTH = 26;
    private static final Integer TIMEOUT_5_SECONDS = 5000;
    private static final Integer TIMEOUT_90_SECONDS = 90000;
    private static final Integer TIMEOUT_PER_PAGE = 50;
    private static final int BYTES_PER_PC_UNIT = 2;
    private final Bootloader16AbstractFactory factory;
    private final ModelProxy model;
    private final Protocol protocol;
    private final EventHandler eventHandler;
    private int pages;
    private Integer minWriteSize;
    private Integer maxPacketSize;
    private final Console16bit console;
    private int erasePageSize = 1;

    BootProtocol(Bootloader16AbstractFactory factory, ModelProxy model, Protocol protocol, EventHandler eventHandler, Console16bit console) {
        this.factory = factory;
        this.model = model;
        this.protocol = protocol;
        this.eventHandler = eventHandler == null ? new EventHandlerImplNull() : eventHandler;
        this.console = console;
    }

    BootProtocol(Bootloader16AbstractFactory factory, ModelProxy model, Protocol protocol, EventHandler eventHandler, Console16bit console, Integer maxPacketSize, Integer minWriteSize) {
        this(factory, model, protocol, eventHandler, console);
        this.maxPacketSize = maxPacketSize;
        this.minWriteSize = minWriteSize;
    }

    public void getVersion() throws IOException, TimeoutException, BadResponseException {
        Command command = new PropCommandBase().setCommand(this.commandFactory.getVersionCommandId());
        Command version = this.getVersionCommandResponse(this.transceiveCommand(command, TIMEOUT_5_SECONDS));
        this.erasePageSize = version.accept(new FnErasePageSizeAccessor());
        this.minWriteSize = version.accept(new FnMinWriteSizeAccessor());
        this.pages = this.model.getPages(this.erasePageSize);
        this.maxPacketSize = version.accept(new FnMaxPacketSize());
        this.printVersionInfo(this.minWriteSize, this.erasePageSize, this.pages, this.maxPacketSize);
    }

    public void open() throws IOException, ProtocolException, ProtocolInUseException {
        this.protocol.open();
    }

    public void close() {
        this.protocol.close();
    }

    public void readBackVerify() throws VerificationException, IOException, TimeoutException, BadResponseException, InvalidRecordException {
        this.eventHandler.readBackVerificationRequested();
        ArrayList<Command> allCommands = new ArrayList<Command>();
        HashMap<Integer, Integer> actual = new HashMap<Integer, Integer>();
        Map<Integer, Integer> filteredImage = this.model.getFilteredImage();
        SegmentedImage segmentedImage = this.factory.makeSegmentedImage(filteredImage);
        for (Segment segment : segmentedImage.makeSegments()) {
            VerificationCommandProducer producer = this.makeVerificationCommandProducer(segment);
            allCommands.addAll(producer.makeCommands());
        }
        double tasksTotal = allCommands.size();
        double tasksComplete = 0.0;
        for (Command command : allCommands) {
            try {
                actual.putAll(this.read(command));
            }
            catch (IOException | BufferUnderflowException | TimeoutException e) {
                throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, null);
            }
            this.eventHandler.setProgress((tasksComplete += 1.0) / tasksTotal);
        }
        for (Map.Entry entry : filteredImage.entrySet()) {
            Integer address = (Integer)entry.getKey();
            Integer expectedValue = (Integer)entry.getValue();
            if (!actual.containsKey(address)) {
                throw new IllegalStateException(String.format("We expected the actual image to contain %x, but it didn't!  This is a unified host bug!", address));
            }
            Integer actualValue = (Integer)actual.get(address);
            if (expectedValue.equals(actualValue)) continue;
            throw new VerificationException(address, actualValue, expectedValue);
        }
        this.eventHandler.readBackVerificationPassed();
    }

    public Map<Integer, Integer> read(Command command) throws IOException, TimeoutException, BadResponseException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        this.printReadRequest(command);
        ByteBuffer out = this.transceiveCommand(command, TIMEOUT_5_SECONDS);
        Command resp = this.getCommonCommandResponse(out);
        Long responseAddress = resp.accept(new FnAddressAccessor());
        while (out.hasRemaining()) {
            int anInt = out.getInt();
            map.put(Math.toIntExact(responseAddress), anInt);
            responseAddress = responseAddress + 2L;
        }
        return map;
    }

    private VerificationCommandProducer makeVerificationCommandProducer(Segment segment) {
        Integer headerSize = this.makeResponsePrototype().accept(new FnPrototypeSizeVisitorImpl());
        int maxResponsePayloadSize = this.maxPacketSize - headerSize;
        return this.factory.makeVerificationCommandProducer(segment, maxResponsePayloadSize);
    }

    private Command makeResponsePrototype() {
        return new PropCommandBase().setCommand(this.commandFactory.getWriteFlashCommandId()).setAddress(0L).setLength(0).setUnlock(this.commandFactory.getUnlockSequence()).setStatus(1);
    }

    public void erase() throws IOException, TimeoutException, BadResponseException, InvalidAddressException {
        Command response;
        this.eventHandler.eraseRequested();
        Command command = new PropCommandBase().setCommand(this.commandFactory.getEraseFlashCommandId()).setLength(this.pages).setUnlock(0xAA0055L).setAddress(this.model.getApplicationStart());
        this.printEraseRequest(command);
        this.eventHandler.setProgress(0.5);
        try {
            response = this.getCommonCommandResponse(this.transceiveCommand(command, TIMEOUT_PER_PAGE * this.pages));
        }
        catch (IOException | BufferUnderflowException | TimeoutException e) {
            throw new BadResponseException(command);
        }
        if (response.accept(new FnStatusAccessor()).intValue() != this.commandStatusFactory.getCommandSuccessId()) {
            if (response.accept(new FnStatusAccessor()).intValue() == this.commandStatusFactory.getAddressErrorId()) {
                throw new InvalidAddressException(command, response);
            }
            throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, response);
        }
        this.eventHandler.setProgress(1.0);
        this.eventHandler.eraseFinished();
    }

    public void program() throws IOException, TimeoutException, BadResponseException, InvalidRecordException, InvalidAddressException {
        this.eventHandler.programmingStarted();
        Integer headerSize = this.factory.makeWriteCommandConsumer().getHeaderSize();
        int maxPayloadSize = this.maxPacketSize - headerSize;
        WriteCommandProducer producer = this.factory.makeWriteCommandProducer(this.model.getFilteredImage(), maxPayloadSize, this.minWriteSize);
        List<Command> commands = producer.makeCommands();
        double tasksTotal = commands.size();
        double[] tasksComplete = new double[]{0.0};
        for (Command command : commands) {
            Command response;
            try {
                this.printProgramRequest(command);
                response = this.getCommonCommandResponse(this.transceiveCommand(command, TIMEOUT_5_SECONDS));
            }
            catch (IOException | BufferUnderflowException | TimeoutException e) {
                throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, null);
            }
            if (response.accept(new FnStatusAccessor()).intValue() != this.commandStatusFactory.getCommandSuccessId()) {
                if (response.accept(new FnStatusAccessor()).intValue() == this.commandStatusFactory.getAddressErrorId()) {
                    throw new InvalidAddressException(command, response);
                }
                throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, response);
            }
            tasksComplete[0] = tasksComplete[0] + 1.0;
            this.eventHandler.setProgress(tasksComplete[0] / tasksTotal);
        }
        this.eventHandler.programmingFinished();
    }

    public void selfVerify() throws IOException, TimeoutException, BadResponseException, SelfVerificationNotSupportedException, SelfVerificationFailedException {
        Command response;
        this.eventHandler.selfVerificationRequested();
        this.eventHandler.setProgress(0.5);
        Command command = new PropCommandBase().setCommand(this.commandFactory.getSelfVerifyCommandId());
        try {
            response = this.getCommonCommandResponse(this.transceiveCommand(command, TIMEOUT_90_SECONDS));
        }
        catch (IOException | BufferUnderflowException | TimeoutException e) {
            throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, null);
        }
        Integer selfVerifyResult = response.accept(new FnStatusAccessor());
        this.eventHandler.setProgress(1.0);
        if (selfVerifyResult.intValue() == this.commandStatusFactory.getVerifyFailId()) {
            throw new SelfVerificationFailedException();
        }
        if (selfVerifyResult.intValue() == this.commandStatusFactory.getCommandUnsupportedId()) {
            throw new SelfVerificationNotSupportedException();
        }
        this.eventHandler.selfVerificationPassed();
    }

    public void reset() throws IOException, BadResponseException, IncompleteResetException {
        this.eventHandler.resetRequested();
        Command command = new PropCommandBase().setCommand(this.commandFactory.getResetDeviceCommandId());
        try {
            this.getCommonCommandResponse(this.transceiveCommand(command, TIMEOUT_5_SECONDS));
        }
        catch (BufferUnderflowException | TimeoutException e) {
            throw new IncompleteResetException();
        }
        this.eventHandler.resetSuccessful();
    }

    public void getDeviceData() throws IOException, TimeoutException, BadResponseException {
        Command response;
        Command command = new PropCommandBase().setCommand(this.commandFactory.getMemoryAddressRangeCommandId()).setLength(8).setUnlock(0L).setAddress(0L);
        try {
            response = this.getMemoryAddressRangeResponse(this.transceiveCommand(command, TIMEOUT_5_SECONDS));
        }
        catch (BufferUnderflowException e) {
            throw new BadResponseException(this.protocol.getHardwareMisconfigurationMessage(), command, null);
        }
        this.model.setMemoryRange(this.getStartAddress(response), this.getEndAddress(response));
    }

    private Command getCommonCommandResponse(ByteBuffer buffer) {
        return new PropCommandBase().setCommand(this.getUnsignedByte(buffer)).setLength(this.getUnsignedShort(buffer)).setUnlock(this.getUnsignedInt(buffer)).setAddress(this.getUnsignedInt(buffer)).setStatus(this.getUnsignedByte(buffer));
    }

    private Command getVersionCommandResponse(ByteBuffer buffer) {
        return new PropCommandBase().setCommand(this.getUnsignedByte(buffer)).setLength(this.getUnsignedShort(buffer)).setUnlock(this.getUnsignedInt(buffer)).setAddress(this.getUnsignedInt(buffer)).setVersion(this.getUnsignedShort(buffer)).setMaxPacketSize(this.getUnsignedShort(buffer)).setDummy(this.getUnsignedShort(buffer), 2).setDeviceId(this.getUnsignedShort(buffer)).setDummy(this.getUnsignedShort(buffer), 2).setErasePageSize(this.getUnsignedShort(buffer)).setMinWriteSize(this.getUnsignedShort(buffer)).setDummy(this.getUnsignedInt(buffer), 4).setStartAddress(this.getUnsignedInt(buffer)).setEndAddress(this.getUnsignedInt(buffer));
    }

    private Command getMemoryAddressRangeResponse(ByteBuffer buffer) {
        return new PropCommandBase().setCommand(this.getUnsignedByte(buffer)).setLength(this.getUnsignedShort(buffer)).setUnlock(this.getUnsignedInt(buffer)).setAddress(this.getUnsignedInt(buffer)).setStatus(this.getUnsignedByte(buffer)).setProgramStartAddress(this.getUnsignedInt(buffer)).setProgramEndAddress(this.getUnsignedInt(buffer));
    }

    private int getUnsignedInt(ByteBuffer buffer) {
        return (int)((long)buffer.getInt() & 0xFFFFFFFFL);
    }

    private short getUnsignedShort(ByteBuffer buffer) {
        return (short)(buffer.getShort() & 0xFFFF);
    }

    private byte getUnsignedByte(ByteBuffer buffer) {
        return (byte)(buffer.get() & 0xFF);
    }

    private Integer getExpectedResponseLength(Command command) {
        Byte commandValue = command.accept(new FnCommandAccessor());
        Integer payloadLength = RESPONSE_HEADER_WITH_STATUS_SIZE + command.accept(new FnDataLengthAccessor());
        if (commandValue.byteValue() == this.commandFactory.getVersionCommandId()) {
            payloadLength = RESPONSE_HEADER_SIZE + GET_VERSION_RESPONSE_LENGTH;
        } else if (commandValue.byteValue() == this.commandFactory.getEraseFlashCommandId() || commandValue.byteValue() == this.commandFactory.getResetDeviceCommandId() || commandValue.byteValue() == this.commandFactory.getWriteFlashCommandId()) {
            payloadLength = RESPONSE_HEADER_WITH_STATUS_SIZE;
        }
        return payloadLength;
    }

    private ByteBuffer transceiveCommand(Command command, Integer timeoutMilliseconds) throws IOException, TimeoutException, BadResponseException {
        ByteBuffer commandData = ByteBuffer.allocate(1000).order(ByteOrder.LITTLE_ENDIAN);
        command.write(commandData);
        ByteBuffer commandDataCopy = commandData.duplicate();
        commandDataCopy.flip();
        this.printCommandPacket(commandDataCopy);
        ByteBuffer response = this.protocol.transceive(commandData, this.getExpectedResponseLength(command), timeoutMilliseconds).order(ByteOrder.LITTLE_ENDIAN);
        this.printResponsePacket(response.duplicate());
        return response;
    }

    private Integer getStartAddress(Command deviceData) {
        return deviceData.accept(new FnProgramStartAddressAccessor());
    }

    private Integer getEndAddress(Command deviceData) {
        return deviceData.accept(new FnProgramEndAddressAccessor());
    }

    static String toHexString(long value) {
        return "0x" + Long.toHexString(value).toUpperCase();
    }

    static String toHexString(byte value) {
        return "0x" + String.format("%1$02X", value);
    }

    void printVersionInfo(Integer minWriteSize, int erasePageSize, int pages, Integer maxPacketSize) {
        ArrayList<String> toPrint = new ArrayList<String>();
        toPrint.add("Device information:");
        toPrint.add("  Minimum write size: " + minWriteSize.toString());
        toPrint.add("  Erase page size: " + Integer.toString(erasePageSize));
        toPrint.add("  Erase pages on device: " + Integer.toString(pages));
        toPrint.add("  Maximum packet size: " + maxPacketSize.toString());
        this.console.addConsoleText(Level.FINE, toPrint);
    }

    void printEraseRequest(Command command) {
        long startAddress = command.accept(new FnAddressAccessor());
        long pageCount = command.accept(new FnDataLengthAccessor()).intValue();
        long endAddress = startAddress + (long)this.erasePageSize * pageCount;
        this.console.addConsoleText(Level.FINE, "Erase " + BootProtocol.toHexString(startAddress) + " to " + BootProtocol.toHexString(endAddress));
    }

    void printByteRangeOperationRequest(String operationDescription, Command command) {
        long startAddress = command.accept(new FnAddressAccessor());
        long length = command.accept(new FnDataLengthAccessor()).intValue();
        long endAddress = startAddress + length / 2L;
        this.console.addConsoleText(Level.FINE, operationDescription + " " + BootProtocol.toHexString(startAddress) + " to " + BootProtocol.toHexString(endAddress));
    }

    void printProgramRequest(Command command) {
        this.printByteRangeOperationRequest("Programming", command);
    }

    void printReadRequest(Command command) {
        this.printByteRangeOperationRequest("Reading", command);
    }

    static String byteBufferToHexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.hasRemaining()) {
            builder.append(BootProtocol.toHexString(buffer.get()));
            if (!buffer.hasRemaining()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    void printPacket(String operationDescription, ByteBuffer packet) {
        this.console.addConsoleText(Level.FINEST, operationDescription + ": " + BootProtocol.byteBufferToHexString(packet));
    }

    void printCommandPacket(ByteBuffer command) {
        this.printPacket("Sent", command);
    }

    void printResponsePacket(ByteBuffer response) {
        this.printPacket("Received", response);
    }
}

