/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import console16bit.Console16bitImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;
import unified.bootloader16bit.Bootloader16AbstractFactory;
import unified.bootloader16bit.Bootloader16Model;
import unified.bootloader16bit.Chonk;
import unified.bootloader16bit.Chunk;
import unified.bootloader16bit.ChunkBuilder;
import unified.bootloader16bit.ChunksToChonksCollectorImpl;
import unified.bootloader16bit.EventHandler;
import unified.bootloader16bit.EventHandlerImpl;
import unified.bootloader16bit.ModelProxy;
import unified.bootloader16bit.ProgramTargetFastImpl;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ReadDeviceDataFastImpl;
import unified.bootloader16bit.Segment;
import unified.bootloader16bit.SegmentFactory;
import unified.bootloader16bit.SegmentFactoryImpl;
import unified.bootloader16bit.SegmentedImage;
import unified.bootloader16bit.SegmentedImageImpl;
import unified.bootloader16bit.VerificationCommandProducer;
import unified.bootloader16bit.VerificationCommandProducerForLinearRangeImpl;
import unified.bootloader16bit.WriteCommandConsumer;
import unified.bootloader16bit.WriteCommandConsumerImpl;
import unified.bootloader16bit.WriteCommandProducer;
import unified.bootloader16bit.WriteCommandProducer8BImpl;
import unified.bootloader16bit.WriteCommandProducerImpl;
import unified.bootloader16bit.hexfile.HexParser;
import unified.bootloader16bit.hexfile.HexParserImpl;

public class Bootloader16AbstractFactoryFastImpl
implements Bootloader16AbstractFactory {
    @Override
    public Console16bit makeConsole() {
        return new Console16bitImpl();
    }

    private HexParser getHexParser() {
        return new HexParserImpl();
    }

    @Override
    public Bootloader16Model makeBootloader16Model() {
        Console16bit console = this.makeConsole();
        HexParser hexParser = this.getHexParser();
        return new Bootloader16Model(this, hexParser, console);
    }

    @Override
    public EventHandler makeEventHandler(ModelProxy modelProxy, Console16bit console) {
        return new EventHandlerImpl(modelProxy, console);
    }

    @Override
    public Runnable makeProgrammer(ModelProxy modelProxy, EventHandler eventHandler, Protocol protocol, Console16bit console) {
        return new ProgramTargetFastImpl(this, modelProxy, protocol, eventHandler, console);
    }

    @Override
    public Runnable makeDeviceReader(ModelProxy modelProxy, EventHandler eventHandler, Protocol protocol, Console16bit console) {
        return new ReadDeviceDataFastImpl(this, modelProxy, protocol, eventHandler, console);
    }

    @Override
    public VerificationCommandProducer makeVerificationCommandProducer(Segment segment, int maxResponsePayloadSize) {
        return new VerificationCommandProducerForLinearRangeImpl(segment.getAddresses(), maxResponsePayloadSize);
    }

    @Override
    public WriteCommandProducer makeWriteCommandProducer(Map<Integer, Integer> image, int maxPayloadSize, int minWriteSize) {
        switch (minWriteSize) {
            case 4: {
                return new WriteCommandProducerImpl(image, this.makeWriteCommandConsumer(), maxPayloadSize);
            }
            case 8: {
                int chunksInAChonk = maxPayloadSize / 8;
                return new WriteCommandProducer8BImpl(image, this.makeCondenserSupplier(chunksInAChonk));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteCommandConsumer makeWriteCommandConsumer() {
        return new WriteCommandConsumerImpl();
    }

    private Supplier<Collector<Chunk, ChunkBuilder, List<Chonk>>> makeCondenserSupplier(int chunksInAChonk) {
        return () -> new ChunksToChonksCollectorImpl(chunksInAChonk);
    }

    @Override
    public SegmentedImage makeSegmentedImage(Map<Integer, Integer> image) {
        return new SegmentedImageImpl(image, this.makeSegmentFactory());
    }

    @Override
    public SegmentFactory makeSegmentFactory() {
        return new SegmentFactoryImpl();
    }
}

