/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.IntConsumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import unified.bootloader16bit.Bootloader16Model;
import unified.bootloader16bit.Bootloader16ModelObserver;

class Bootloader16Controller
implements Initializable {
    @FXML
    public ProgressBar progress;
    @FXML
    public TextField endAddress;
    @FXML
    public TextField startAddress;
    @FXML
    public Label labelStatusResult;
    @FXML
    public Label labelConfigStatus;
    @FXML
    public Button programButton;
    @FXML
    public CheckBox resetCheckBox;
    @FXML
    public CheckBox readBackVerifyCheckBox;
    @FXML
    private ComboBox<String> protocolSelect;
    @FXML
    public CheckBox selfVerifyCheckBox;
    private final Bootloader16Model model;

    public Bootloader16Controller(Bootloader16Model model) {
        this.model = model;
    }

    @FXML
    public void programDevice(ActionEvent actionEvent) {
        this.model.program();
    }

    @FXML
    public void readDeviceSettings(ActionEvent actionEvent) {
        this.model.readDeviceSettings();
    }

    private String formatAddress(Integer address) {
        return String.format("0x%X", address);
    }

    private List<String> getSupportedProtocolCodes() {
        ArrayList<String> supportedProtocolCodes = new ArrayList<String>();
        supportedProtocolCodes.add("UART");
        supportedProtocolCodes.add("CAN");
        supportedProtocolCodes.add("I2C");
        supportedProtocolCodes.add("LIN");
        return supportedProtocolCodes;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.protocolSelect.setItems(FXCollections.observableArrayList(this.getSupportedProtocolCodes()));
        Bootloader16ModelObserver modelObserver = new Bootloader16ModelObserver(d -> this.fx(() -> this.progress.progressProperty().set(d.doubleValue())), s0 -> this.fx(() -> this.labelStatusResult.setText(s0)), s1 -> this.fx(() -> this.labelConfigStatus.setText(s1)), b -> this.fx(() -> this.programButton.setDisable(b.booleanValue())), sa -> this.fx(() -> this.startAddress.setText(this.formatAddress((Integer)sa))), ea -> this.fx(() -> this.endAddress.setText(this.formatAddress((Integer)ea))), p -> this.fx(() -> this.protocolSelect.getSelectionModel().select(p)));
        this.model.addObserver(modelObserver);
        modelObserver.update(this.model, null);
        this.startAddress.setText(this.formatAddress(this.model.getStartAddress()));
        this.endAddress.setText(this.formatAddress(this.model.getEndAddress()));
        this.protocolSelect.getSelectionModel().select((Object)this.model.getProtocolType().get());
        this.resetCheckBox.selectedProperty().set(this.model.isResetEnabled());
        this.readBackVerifyCheckBox.selectedProperty().set(this.model.isReadBackVerifyEnabled());
        this.selfVerifyCheckBox.selectedProperty().set(this.model.isSelfVerifyEnabled());
        this.startAddress.textProperty().addListener(this.getValue(this.model::setStartAddress));
        this.endAddress.textProperty().addListener(this.getValue(this.model::setEndAddress));
        this.resetCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.model.setResetEnabled((boolean)newValue));
        this.readBackVerifyCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.model.setReadBackVerifyEnabled((boolean)newValue));
        this.selfVerifyCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.model.setSelfVerifyEnabled((boolean)newValue));
        this.protocolSelect.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.model.setProtocolType((String)newValue));
    }

    public ChangeListener<String> getValue(IntConsumer consumer) {
        return (observable, oldValue, newValue) -> consumer.accept(Bootloader16ModelObserver.getAddressValue(oldValue, newValue));
    }

    private void fx(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }
}

