/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.SimpleStringProperty;
import unified.bootloader16bit.Bootloader16AbstractFactory;
import unified.bootloader16bit.EventHandler;
import unified.bootloader16bit.GuardBy;
import unified.bootloader16bit.ModelProxyImpl;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolFactory;
import unified.bootloader16bit.hexfile.HexParser;
import unified.bootloader16bit.hexfile.InvalidRecordException;

public class Bootloader16Model
extends Observable {
    private final Bootloader16AbstractFactory factory;
    private final HexParser hexParser;
    private static final int DEFAULT_APP_START = 12288;
    private static final int DEFAULT_APP_END = 45056;
    private final Console16bit console;
    private Protocol protocol;
    @GuardBy(value="this")
    private Double progress;
    @GuardBy(value="this")
    private String configStatus;
    @GuardBy(value="this")
    private int startAddress;
    @GuardBy(value="this")
    private int endAddress;
    @GuardBy(value="this")
    private String statusResult;
    @GuardBy(value="this")
    private boolean resetEnabled;
    @GuardBy(value="this")
    private boolean readBackVerifyEnabled;
    @GuardBy(value="this")
    private boolean selfVerifyEnabled;
    @GuardBy(value="this")
    private final Map<Integer, Integer> parse;
    @GuardBy(value="this")
    private File hexFile;
    @GuardBy(value="self")
    private AtomicBoolean isProgramming;
    @GuardBy(value="this")
    private SimpleStringProperty protocolString;
    static final int BYTES_PER_PC = 2;
    static final String DEFAULT_PROTOCOL_SELECTION = "UART";
    private final ExecutorService service = Executors.newSingleThreadExecutor();

    Bootloader16Model(Bootloader16AbstractFactory factory, HexParser hexParser, Console16bit console) {
        this.factory = factory;
        this.parse = new HashMap<Integer, Integer>();
        this.startAddress = 12288;
        this.endAddress = 45056;
        this.resetEnabled = true;
        this.readBackVerifyEnabled = true;
        this.selfVerifyEnabled = false;
        this.hexParser = hexParser;
        this.console = console;
        this.progress = 0.0;
        this.isProgramming = new AtomicBoolean(false);
        this.protocolString = new SimpleStringProperty(DEFAULT_PROTOCOL_SELECTION);
        this.protocol = ProtocolFactory.getProtocol(DEFAULT_PROTOCOL_SELECTION, console, exception -> {
            EventHandler eventHandler = factory.makeEventHandler(new ModelProxyImpl(this), console);
            eventHandler.exception((Exception)exception);
        });
    }

    public void setHexFileName(File hexFile) {
        this.parse.clear();
        this.hexFile = hexFile;
        this.setChanged();
        this.notifyObservers();
        this.console.addConsoleText("Selected Hex File: " + hexFile.getPath());
    }

    private File getHexFile() {
        return this.hexFile;
    }

    public void showProtocolConfig() {
        this.protocol.config();
    }

    private Future<Boolean> run(Runnable runnable) {
        EventHandler eventHandler = this.getEventHandler();
        try {
            this.service.submit(this.notifyProgrammingStarted());
            this.service.submit(this.makeExceptionHandler(this.service.submit(runnable, true), this.getEventHandler()));
            this.service.submit(this.notifyProgrammingStopped());
            return this.service.submit(this.makeExceptionHandler(this.service.submit(this.protocol::close, true), eventHandler), true);
        }
        catch (NoClassDefFoundError e) {
            eventHandler.noClassDefError(e);
        }
        catch (Exception e) {
            eventHandler.exception(e);
        }
        return this.service.submit(() -> {}, false);
    }

    private EventHandler getEventHandler() {
        return this.factory.makeEventHandler(new ModelProxyImpl(this), this.console);
    }

    Future<Boolean> program() {
        return this.run(this.factory.makeProgrammer(new ModelProxyImpl(this), this.getEventHandler(), this.protocol, this.console));
    }

    Future<Boolean> readDeviceSettings() {
        return this.run(this.factory.makeDeviceReader(new ModelProxyImpl(this), this.getEventHandler(), this.protocol, this.console));
    }

    Runnable notifyProgrammingStopped() {
        return () -> {
            this.isProgramming.set(false);
            this.setChanged();
            this.notifyObservers();
        };
    }

    Runnable notifyProgrammingStarted() {
        return () -> {
            this.isProgramming.set(true);
            this.setChanged();
            this.notifyObservers();
        };
    }

    private Runnable makeExceptionHandler(Future<Boolean> submit, EventHandler eventHandler) {
        return () -> {
            try {
                submit.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                eventHandler.interruptException(e);
            }
            catch (ExecutionException e) {
                eventHandler.executionException(e);
            }
        };
    }

    synchronized boolean isResetEnabled() {
        return this.resetEnabled;
    }

    synchronized void setResetEnabled(boolean isEnabled) {
        this.resetEnabled = isEnabled;
    }

    synchronized boolean isReadBackVerifyEnabled() {
        return this.readBackVerifyEnabled;
    }

    synchronized boolean isSelfVerifyEnabled() {
        return this.selfVerifyEnabled;
    }

    synchronized void setReadBackVerifyEnabled(boolean isEnabled) {
        this.readBackVerifyEnabled = isEnabled;
    }

    synchronized void setSelfVerifyEnabled(boolean isEnabled) {
        this.selfVerifyEnabled = isEnabled;
    }

    public synchronized Double getProgress() {
        return this.progress;
    }

    synchronized String getStatusResult() {
        return this.statusResult;
    }

    synchronized String getConfigState() {
        return this.configStatus;
    }

    public synchronized SimpleStringProperty getProtocolType() {
        return this.protocolString;
    }

    public synchronized void setProtocolType(String protocolString) {
        this.protocolString.set(protocolString);
        this.protocol = ProtocolFactory.getProtocol(protocolString, this.console, exception -> {
            EventHandler eventHandler = this.factory.makeEventHandler(new ModelProxyImpl(this), this.console);
            eventHandler.exception((Exception)exception);
        });
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setProgress(double progress) {
        this.progress = progress;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized int getStartAddress() {
        return this.startAddress;
    }

    public synchronized int getEndAddress() {
        return this.endAddress;
    }

    public synchronized void setMemoryRange(int startAddress, int endAddress) {
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setStartAddress(int startAddress) {
        this.startAddress = startAddress;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setEndAddress(int endAddress) {
        this.endAddress = endAddress;
        this.setChanged();
        this.notifyObservers();
    }

    synchronized void setStatusResult(String message) {
        this.statusResult = message;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized Map<Integer, Integer> getImage() throws InvalidRecordException {
        try {
            this.parse.clear();
            this.parse.putAll(this.hexParser.parse(this.getHexFile().toPath()));
            return this.parse;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    Boolean getProgramDisable() {
        File file = this.getHexFile();
        return !this.protocol.ready() || file == null || !file.exists() || this.isProgramming.get();
    }

    public void displayConsole() {
        this.console.displayConsole();
    }

    Map<Integer, Integer> getFilteredImage() throws InvalidRecordException {
        Map<Integer, Integer> image = this.getImage();
        HashMap<Integer, Integer> image2 = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> e : image.entrySet()) {
            Integer addr = e.getKey();
            if (addr < this.getStartAddress() || addr >= this.getEndAddress() + 2) continue;
            image2.put(e.getKey(), e.getValue());
        }
        return image2;
    }

    public void setProtocol(Protocol newProtocol) {
        this.protocol = newProtocol;
    }

    Protocol getProtocol() {
        return this.protocol;
    }
}

