/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.io.File;
import java.io.IOException;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import toplevel.TopLevelArchictecure;
import unified.bootloader16bit.Bootloader16AbstractFactory;
import unified.bootloader16bit.Bootloader16AbstractFactoryFastImpl;
import unified.bootloader16bit.Bootloader16Controller;
import unified.bootloader16bit.Bootloader16Model;

public class Bootloader16TargetDevice
implements TopLevelArchictecure {
    private final Bootloader16Model bootloader16Model;

    public Bootloader16TargetDevice() {
        this(new Bootloader16AbstractFactoryFastImpl());
    }

    public Bootloader16TargetDevice(Bootloader16AbstractFactory factory) {
        this.bootloader16Model = factory.makeBootloader16Model();
    }

    @Override
    public Parent getViewer() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("bootloader16.fxml"));
            fxmlLoader.setControllerFactory(param -> new Bootloader16Controller(this.getModel()));
            return (Parent)fxmlLoader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Bootloader16Model getModel() {
        return this.bootloader16Model;
    }

    @Override
    public SimpleStringProperty getProtocolType() {
        return this.getModel().getProtocolType();
    }

    @Override
    public void showConsole() {
        this.getModel().displayConsole();
    }

    @Override
    public void showProtocolSettings() {
        this.getModel().showProtocolConfig();
    }

    @Override
    public void setHexFile(File file) {
        this.getModel().setHexFileName(file.getAbsoluteFile());
    }
}

