/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import unified.bootloader16bit.Chonk;
import unified.bootloader16bit.ChonkBuilderImpl;
import unified.bootloader16bit.Chunk;
import unified.bootloader16bit.ChunkBuilder;

class ChunksToChonksCollectorImpl
implements Collector<Chunk, ChunkBuilder, List<Chonk>> {
    private int chunksThisChonk;
    private int chunksInAChonk;

    public ChunksToChonksCollectorImpl(int chunksInAChonk) {
        this.chunksInAChonk = chunksInAChonk;
        this.chunksThisChonk = 0;
    }

    @Override
    public Supplier<ChunkBuilder> supplier() {
        return () -> new ChonkBuilderImpl(new ArrayList<Chonk>());
    }

    @Override
    public BiConsumer<ChunkBuilder, Chunk> accumulator() {
        return (build, chunk) -> {
            if (this.chunksThisChonk == this.chunksInAChonk) {
                build.startNewChonk();
                build.addChunk((Chunk)chunk);
                this.chunksThisChonk = 1;
            } else {
                ++this.chunksThisChonk;
                build.addChunk((Chunk)chunk);
            }
        };
    }

    @Override
    public BinaryOperator<ChunkBuilder> combiner() {
        return ChunkBuilder::combine;
    }

    @Override
    public Function<ChunkBuilder, List<Chonk>> finisher() {
        return builder -> {
            builder.finish();
            return builder.getChonks();
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

