/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.List;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandSegment;
import unified.bootloader16bit.FnCommandVisitor;
import unified.bootloader16bit.FnDeconstructor;
import unified.bootloader16bit.PropAddress;
import unified.bootloader16bit.PropCommand;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.PropDeviceId;
import unified.bootloader16bit.PropDummy;
import unified.bootloader16bit.PropEndAddress;
import unified.bootloader16bit.PropErasePageSize;
import unified.bootloader16bit.PropLength;
import unified.bootloader16bit.PropMaxPacketSize;
import unified.bootloader16bit.PropMinWriteSize;
import unified.bootloader16bit.PropProgramEndAddress;
import unified.bootloader16bit.PropProgramRegionId;
import unified.bootloader16bit.PropProgramStartAddress;
import unified.bootloader16bit.PropProgramWord;
import unified.bootloader16bit.PropStartAddress;
import unified.bootloader16bit.PropStatus;
import unified.bootloader16bit.PropUnlockCode;
import unified.bootloader16bit.PropVersion;

public class FnNormalize
implements FnCommandVisitor<Command> {
    @Override
    public Command forDummy(Command others, int size) {
        return this.reduce(new PropDummy(others, size).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forVersion(Command others, int version) {
        return this.reduce(new PropVersion(others, version).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forMinWriteSize(Command others, int minWriteSize) {
        return this.reduce(new PropMinWriteSize(others, minWriteSize).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forMaxPacketSize(Command others, int maxPacketSize) {
        return this.reduce(new PropMaxPacketSize(others, maxPacketSize).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forErasePageSize(Command others, int erasePageSize) {
        return this.reduce(new PropErasePageSize(others, erasePageSize).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forStartAddress(Command others, long startAddress) {
        return this.reduce(new PropStartAddress(others, startAddress).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forEndAddress(Command others, long endAddress) {
        return this.reduce(new PropEndAddress(others, endAddress).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forDeviceId(Command others, int deviceId) {
        return this.reduce(new PropDeviceId(others, deviceId).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forBase() {
        return new PropCommandBase();
    }

    @Override
    public Command forCommand(Command others, int cmd) {
        return this.reduce(new PropCommand(others, cmd).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forLength(Command others, int length) {
        return this.reduce(new PropLength(others, length).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forUnlock(Command others, long unlock) {
        return this.reduce(new PropUnlockCode(others, unlock).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forAddress(Command others, long address) {
        return this.reduce(new PropAddress(others, address).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forData(Command others, int data) {
        return this.reduce(new PropProgramWord(others, data).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forStatus(Command others, int status) {
        return this.reduce(new PropStatus(others, status).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forProgramStartAddress(Command others, long startAddress) {
        return this.reduce(new PropProgramStartAddress(others, startAddress).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forProgramEndAddress(Command others, long endAddress) {
        return this.reduce(new PropProgramEndAddress(others, endAddress).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    @Override
    public Command forProgramRegionId(Command others, int region) {
        return this.reduce(new PropProgramRegionId(others, region).accept(new FnDeconstructor(new ArrayList<CommandSegment>())));
    }

    private Command reduce(List<CommandSegment> ll) {
        if (ll.isEmpty()) {
            return new PropCommandBase();
        }
        CommandSegment first = ll.remove(0);
        return first.attach(this.reduce(ll));
    }
}

