/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import unified.bootloader16bit.Segment;

public class SegmentImpl
implements Segment {
    private final Integer inclusiveStart;
    private final Integer exclusiveEnd;
    private static final int WORD_SIZE = 4;

    SegmentImpl(Integer inclusiveStart, Integer exclusiveEnd) {
        this.inclusiveStart = inclusiveStart;
        this.exclusiveEnd = exclusiveEnd;
    }

    @Override
    public List<Integer> getAddresses() {
        return IntStream.range(this.inclusiveStart, this.exclusiveEnd).boxed().filter(SegmentImpl::isEven).collect(Collectors.toList());
    }

    private static boolean isEven(Integer integer) {
        return integer % 2 == 0;
    }

    @Override
    public int getExclusiveEnd() {
        return this.exclusiveEnd;
    }

    @Override
    public int getInclusiveStart() {
        return this.inclusiveStart;
    }

    @Override
    public int getLength() {
        return (this.exclusiveEnd - this.inclusiveStart) / 2 * 4;
    }
}

