/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.List;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandFactory;
import unified.bootloader16bit.CommandFactoryImpl;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.VerificationCommandProducer;

public class VerificationCommandProducerForLinearRangeImpl
implements VerificationCommandProducer {
    private final List<Integer> addresses;
    private final int maxResponsePayloadSize;
    private final CommandFactory commandFactory = new CommandFactoryImpl();
    private static final int BYTES_PER_ADDRESS = 4;

    public VerificationCommandProducerForLinearRangeImpl(List<Integer> addresses, int maxResponsePayloadSize) {
        this.addresses = new ArrayList<Integer>(addresses);
        this.maxResponsePayloadSize = maxResponsePayloadSize;
    }

    @Override
    public List<Command> makeCommands() {
        ArrayList<Integer> addressQueue = new ArrayList<Integer>(this.addresses);
        ArrayList<Command> commands = new ArrayList<Command>();
        while (!addressQueue.isEmpty()) {
            int lengthInBytes = this.getCommandLengthInBytes(addressQueue);
            Command command = new PropCommandBase().setCommand(this.commandFactory.getReadFlashCommandId()).setUnlock(this.commandFactory.getUnlockSequence()).setAddress(addressQueue.get(0).intValue()).setLength(lengthInBytes);
            commands.add(command);
            this.removeUsedAddresses(addressQueue, lengthInBytes / 4);
        }
        return commands;
    }

    private void removeUsedAddresses(ArrayList<Integer> addressQueue, int addressesToRemove) {
        while (addressesToRemove-- != 0) {
            addressQueue.remove(0);
        }
    }

    private int getCommandLengthInBytes(ArrayList<Integer> addressQueue) {
        return Math.min(this.maxResponsePayloadSize, addressQueue.size() * 4);
    }
}

