/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import unified.bootloader16bit.Chonk;
import unified.bootloader16bit.Chunk;
import unified.bootloader16bit.ChunkBuilder;
import unified.bootloader16bit.ChunkImpl;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandFactory;
import unified.bootloader16bit.CommandFactoryImpl;
import unified.bootloader16bit.CommandWriteOrderCollector;
import unified.bootloader16bit.FnIsDegenerate;
import unified.bootloader16bit.FnWriteDataByteCounter;
import unified.bootloader16bit.WriteCommandProducer;

public class WriteCommandProducer8BImpl
implements WriteCommandProducer {
    private final Map<Integer, Integer> image;
    private final CommandFactory factory;
    private final Supplier<Collector<Chunk, ChunkBuilder, List<Chonk>>> chunksToChonksCollector;

    WriteCommandProducer8BImpl(Map<Integer, Integer> image, Supplier<Collector<Chunk, ChunkBuilder, List<Chonk>>> collectorSupplier) {
        this.image = image;
        this.factory = new CommandFactoryImpl();
        this.chunksToChonksCollector = collectorSupplier;
    }

    @Override
    public List<Command> makeCommands() {
        if (this.image.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getChunks().stream().collect(this.chunksToChonksCollector.get()).stream().map(this.chonkToCommand()).filter(this.getDegeneracyFilter()).collect(this.getCommandOrderCollector());
    }

    private CommandWriteOrderCollector getCommandOrderCollector() {
        return new CommandWriteOrderCollector();
    }

    private Predicate<Command> getDegeneracyFilter() {
        return command -> command.accept(new FnIsDegenerate()) == false;
    }

    private List<Chunk> getChunks() {
        Integer minAddress = this.getMin();
        Integer maxAddress = Collections.max(this.image.keySet());
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int address = minAddress.intValue(); address <= maxAddress; address += 4) {
            int defaultValue = 0xFFFFFF;
            Integer lo = this.image.getOrDefault(address, defaultValue);
            Integer hi = this.image.getOrDefault(address + 2, defaultValue);
            ChunkImpl chunk = new ChunkImpl(address, lo, hi);
            chunks.add(chunk);
        }
        return chunks;
    }

    private Integer getMin() {
        Integer min = Collections.min(this.image.keySet());
        if (min % 4 == 0) {
            return min;
        }
        return min - 2;
    }

    private Function<Chonk, Command> chonkToCommand() {
        return chonk -> {
            Command command = this.factory.makeBase().setCommand(this.factory.getWriteFlashCommandId()).setUnlock(this.factory.getUnlockSequence()).setAddress(chonk.getAddress().intValue()).setLength(0);
            for (Integer i : chonk.getWords()) {
                command = command.addWord(i);
            }
            command = command.setLength(command.accept(new FnWriteDataByteCounter()));
            return command;
        };
    }
}

