/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import unified.bootloader16bit.Styles;
import unified.bootloader16bit.phy.i2c.I2CAddressFormat;
import unified.bootloader16bit.phy.i2c.I2CBitrate;
import unified.bootloader16bit.phy.i2c.Model;

public class Controller
implements Initializable {
    @FXML
    public TextField i2cAddress;
    @FXML
    public ComboBox<I2CBitrate> i2cBitrate;
    @FXML
    public Button settingUpdate;
    @FXML
    public Button buttonRefresh;
    @FXML
    public ComboBox<String> i2cAdapter;
    @FXML
    public TextFlow addressDescription;
    @FXML
    public Label a0;
    @FXML
    public Label a1;
    @FXML
    public Label a2;
    @FXML
    public Label a3;
    @FXML
    public Label a4;
    @FXML
    public Label a5;
    @FXML
    public Label a6;
    private final Stage dialogStage;
    private final Model model;
    private SimpleObjectProperty<ObservableList<String>> i2cAdapterProperty;
    private SimpleObjectProperty<ObservableList<I2CBitrate>> i2cBitrateProperty;

    Controller(Stage stage, Model model) {
        this.dialogStage = stage;
        this.model = model;
    }

    @FXML
    public void actionApplySettings(ActionEvent actionEvent) {
        this.model.setPort((String)this.i2cAdapter.getSelectionModel().getSelectedItem());
        this.model.setBitrate(((I2CBitrate)this.i2cBitrate.getSelectionModel().getSelectedItem()).getValue());
        Optional<Integer> address = I2CAddressFormat.getAddress(this.i2cAddress.getText());
        if (address.isPresent()) {
            this.model.setAddress(address.get());
        }
        this.dialogStage.close();
    }

    @FXML
    public void actionRefreshComList(ActionEvent actionEvent) {
        ((ObservableList)this.i2cAdapterProperty.get()).setAll(this.model.getPorts());
        this.i2cAdapter.getSelectionModel().select((Object)this.model.getPort());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.renderRefreshButton();
        this.i2cAdapterProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.i2cAdapterProperty.bind((ObservableValue)this.i2cAdapter.itemsProperty());
        ((ObservableList)this.i2cAdapterProperty.get()).setAll(this.model.getPorts());
        this.i2cAdapter.getSelectionModel().select((Object)this.model.getPort());
        this.i2cAddress.setText(this.toHexString(this.model.getAddress()));
        this.i2cBitrateProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.i2cBitrateProperty.bind((ObservableValue)this.i2cBitrate.itemsProperty());
        ((ObservableList)this.i2cBitrateProperty.get()).setAll(Controller.getBitrateList());
        this.i2cBitrate.getSelectionModel().select((Object)Controller.getBitrate(this.model.getBitrate()));
        this.i2cAddress.textProperty().addListener((observable, oldValue, newValue) -> this.validateInputs());
        this.i2cAddress.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(this.i2cAddress));
        Text addressDescriptionText = new Text("Valid 7-bit address range is: 0x77-0x08.");
        addressDescriptionText.setFill((Paint)Styles.Text.VALID);
        this.addressDescription.getChildren().add((Object)addressDescriptionText);
        this.validateInputs();
    }

    private void setHexPrefix(TextField textField) {
        if (!textField.isFocused() && !((String)textField.textProperty().get()).startsWith("0x") && I2CAddressFormat.isNumber((String)textField.textProperty().get())) {
            textField.textProperty().set((Object)("0x" + (String)textField.textProperty().get()));
        }
    }

    private boolean validateAddressFields() {
        Optional<Integer> address = I2CAddressFormat.getAddress(this.i2cAddress.getText());
        if (address.isPresent()) {
            this.set7bitAddress(address.get());
            this.i2cAddress.setStyle("-fx-control-inner-background: white");
        } else {
            this.setInvalidAddress();
            this.i2cAddress.setStyle("-fx-control-inner-background: lightpink");
        }
        return address.isPresent();
    }

    private void validateInputs() {
        boolean disableUpdate = false;
        this.settingUpdate.disableProperty().set(disableUpdate |= !this.validateAddressFields());
    }

    private static I2CBitrate getBitrate(int rate) {
        List<I2CBitrate> list = Controller.getBitrateList();
        return list.stream().filter(bitrate -> bitrate.getValue() == rate).findFirst().orElse(list.get(0));
    }

    private static List<I2CBitrate> getBitrateList() {
        ArrayList<I2CBitrate> list = new ArrayList<I2CBitrate>();
        list.add(new I2CBitrate(100000, "100 kbits/s"));
        list.add(new I2CBitrate(400000, "400 kbits/s"));
        return list;
    }

    private void renderRefreshButton() {
        Image imageRefresh = new Image(this.getClass().getResourceAsStream("/portSettings/refreshIcon.png"));
        ImageView imageButtonRefresh = new ImageView();
        imageButtonRefresh.setImage(imageRefresh);
        imageButtonRefresh.setFitWidth(20.0);
        imageButtonRefresh.setPreserveRatio(true);
        imageButtonRefresh.setSmooth(true);
        imageButtonRefresh.setCache(true);
        this.buttonRefresh.setGraphic((Node)imageButtonRefresh);
    }

    private String toHexString(Integer value) {
        return "0x" + Integer.toHexString(value).toUpperCase();
    }

    private void set7bitAddress(int address) {
        this.setBitLabel(address, 0, this.a0);
        this.setBitLabel(address, 1, this.a1);
        this.setBitLabel(address, 2, this.a2);
        this.setBitLabel(address, 3, this.a3);
        this.setBitLabel(address, 4, this.a4);
        this.setBitLabel(address, 5, this.a5);
        this.setBitLabel(address, 6, this.a6);
    }

    private void setBitLabel(int value, int bitPosition, Label label) {
        if (this.isBitSet(value, bitPosition)) {
            label.setText("1");
        } else {
            label.setText("0");
        }
    }

    private boolean isBitSet(int value, int bitPosition) {
        return (value & 1 << bitPosition) != 0;
    }

    private void setInvalidAddress() {
        this.a0.setText("A0");
        this.a1.setText("A1");
        this.a2.setText("A2");
        this.a3.setText("A3");
        this.a4.setText("A4");
        this.a5.setText("A5");
        this.a6.setText("A6");
    }
}

