/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import unified.bootloader16bit.phy.AModel;

public class Model
extends AModel {
    private Integer bitrate;
    private Integer addressLength;
    private Integer address;

    public Model() {
        this(Collections::emptyList);
    }

    public Model(Supplier<List<String>> portsSuppiler) {
        this.portSupplier = portsSuppiler;
        this.bitrate = 100000;
        this.addressLength = 7;
        this.address = 8;
    }

    public Integer getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(Integer bitrate) {
        this.bitrate = bitrate;
        this.setChanged();
        this.notifyObservers();
    }

    public void setAddressLength(Integer addressLength) {
        if (this.getValidAddressLengths().contains(addressLength)) {
            this.addressLength = addressLength;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Integer getAddressLength() {
        return this.addressLength;
    }

    public void setAddress(Integer address) {
        this.address = address;
        this.setChanged();
        this.notifyObservers();
    }

    public Integer getAddress() {
        return this.address;
    }

    public List<Integer> getValidAddressLengths() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(7);
        list.add(8);
        return list;
    }
}

