/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.nio.ByteBuffer;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.InvalidPduException;
import unified.bootloader16bit.phy.lin.Pdu;

public class PduSingleFrame
implements Pdu {
    public static final int MAX_DATA_LENGTH = 5;
    private static final int LENGTH_INDEX = 1;
    private static final int SERVICE_ID_INDEX = 2;
    private static final int DATA_START_INDEX = 3;
    private final byte nodeAddress;
    private final byte serviceId;
    private final byte[] data;

    private PduSingleFrame(byte nodeAddress, byte serviceId, byte[] data) {
        this.nodeAddress = nodeAddress;
        this.serviceId = serviceId;
        this.data = data;
    }

    public static PduSingleFrame create(byte[] frame) throws InvalidPduException {
        if (frame.length != 8) {
            throw new InvalidPduException("Invalid frame length: " + frame.length);
        }
        if (!Pdu.Type.get(frame).equals((Object)Pdu.Type.SINGLE_FRAME)) {
            throw new InvalidPduException("Invalid frame type: " + (Object)((Object)Pdu.Type.get(frame)));
        }
        int length = PduSingleFrame.getLength(frame[1]);
        if (length < 1) {
            throw new InvalidPduException("Invalid frame data length: " + length);
        }
        byte[] data = new byte[length - 1];
        PduSingleFrame.validateFrameLength(data.length);
        System.arraycopy(frame, 3, data, 0, data.length);
        return new PduSingleFrame(Pdu.getNodeAddress(frame), frame[2], data);
    }

    public static PduSingleFrame create(byte nodeAddress, byte serviceId, ByteBuffer dataBuffer) throws InvalidPduException {
        PduSingleFrame.validateFrameLength(dataBuffer.remaining());
        return new PduSingleFrame(nodeAddress, serviceId, dataBuffer.array());
    }

    private static void validateFrameLength(int length) throws InvalidPduException {
        if (length > 5) {
            throw new InvalidPduException("Too much data provided for a single frame message");
        }
    }

    private static int getLength(byte pci) {
        return pci & 0xF;
    }

    @Override
    public byte[] get() {
        byte protocolControlInformation = (byte)(this.data.length + 1);
        byte[] frame = new byte[]{this.nodeAddress, protocolControlInformation, this.serviceId, -1, -1, -1, -1, -1};
        System.arraycopy(this.data, 0, frame, 3, this.data.length);
        return frame;
    }

    @Override
    public byte getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public Pdu.Type getType() {
        return Pdu.Type.SINGLE_FRAME;
    }

    @Override
    public Optional<Integer> getLength() {
        return Optional.of(this.data.length + 1);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Optional<Byte> getServiceId() {
        return Optional.of(this.serviceId);
    }

    @Override
    public Optional<Integer> getSequenceNumber() {
        return Optional.empty();
    }
}

