/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import unified.bootloader16bit.phy.lin.InvalidPduException;
import unified.bootloader16bit.phy.lin.Message;
import unified.bootloader16bit.phy.lin.Pdu;
import unified.bootloader16bit.phy.lin.PduConsecutiveFrame;
import unified.bootloader16bit.phy.lin.PduFirstFrame;
import unified.bootloader16bit.phy.lin.PduSingleFrame;

class RequestSegmenter {
    private static final Logger LOGGER = Logger.getLogger(RequestSegmenter.class.getName());

    private RequestSegmenter() {
    }

    private static List<Pdu> createSegmentedMessagePdus(byte nodeAddress, byte serviceId, ByteBuffer dataBuffer) throws InvalidPduException {
        ArrayList<Pdu> frames = new ArrayList<Pdu>();
        int sequenceNumber = 1;
        frames.add(PduFirstFrame.create(nodeAddress, serviceId, dataBuffer));
        while (dataBuffer.hasRemaining()) {
            frames.add(PduConsecutiveFrame.create(nodeAddress, sequenceNumber, dataBuffer));
            sequenceNumber = PduConsecutiveFrame.getNextSequenceNumber(sequenceNumber);
        }
        return frames;
    }

    static List<Pdu> generatePdus(Message message) {
        return RequestSegmenter.generatePdus(message.getNodeAddress(), message.getServiceId(), ByteBuffer.wrap(message.getData()));
    }

    static List<Pdu> generatePdus(byte nodeAddress, byte serviceId, ByteBuffer dataBuffer) {
        if (dataBuffer == null) {
            return Collections.emptyList();
        }
        ArrayList<Pdu> frames = new ArrayList<Pdu>();
        try {
            if (dataBuffer.remaining() <= 5) {
                frames.add(PduSingleFrame.create(nodeAddress, serviceId, dataBuffer));
            } else {
                frames.addAll(RequestSegmenter.createSegmentedMessagePdus(nodeAddress, serviceId, dataBuffer));
            }
        }
        catch (InvalidPduException ex) {
            LOGGER.log(Level.SEVERE, "An invalid PDU was created.  Message PDU generation has been aborted.");
            return Collections.emptyList();
        }
        return frames;
    }
}

