/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import console16bit.Console16bit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import unified.bootloader16bit.SleepProvider;
import unified.bootloader16bit.SleepProviderImpl;
import unified.bootloader16bit.phy.lin.ChecksumType;
import unified.bootloader16bit.phy.lin.FrameTransceiver;
import unified.bootloader16bit.phy.lin.Pid;
import unified.bootloader16bit.phy.lin.plin.DLLWrapper;
import unified.bootloader16bit.phy.lin.plin.DLLWrapperImpl;
import unified.bootloader16bit.phy.lin.plin.TLINChecksumType;
import unified.bootloader16bit.phy.lin.plin.TLINDirection;
import unified.bootloader16bit.phy.lin.plin.TLINError;
import unified.bootloader16bit.phy.lin.plin.TLINHardwareMode;
import unified.bootloader16bit.phy.lin.plin.TLINMsg;
import unified.bootloader16bit.phy.lin.plin.TLINRcvMsg;

public class PLinFrameTransceiver
implements FrameTransceiver {
    private final Console16bit console;
    private DLLWrapper dll;
    private Byte hClient;
    private Integer hHardware;
    private boolean isOpen;
    private final SleepProvider sleepProvider;
    private final List<Integer> registeredIds = new ArrayList<Integer>();
    private static final long FRAME_DELAY_TIME_MS = 20L;
    private static final String HARDWARE_CONNECTION_ISSUE = "There was an error trying to connect to the requested device.";
    private static final String CLIENT_NAME = "UBHA";
    private static final Map<ChecksumType, TLINChecksumType> checksumConverter = new EnumMap<ChecksumType, TLINChecksumType>(ChecksumType.class);

    public PLinFrameTransceiver(Console16bit console) {
        this(console, new DLLWrapperImpl(), new SleepProviderImpl());
    }

    public PLinFrameTransceiver(Console16bit console, DLLWrapper dll, SleepProvider sleepProvider) {
        this.dll = Objects.requireNonNull(dll);
        this.console = Objects.requireNonNull(console);
        this.sleepProvider = sleepProvider;
        this.isOpen = false;
    }

    private Byte registerClient() throws HardwareConnectionIssue {
        return Optional.ofNullable(this.dll.registerClient(CLIENT_NAME)).orElseThrow(() -> new HardwareConnectionIssue("Unable to register client: UBHA"));
    }

    private Integer getHardwareHandle(String id) throws HardwareConnectionIssue {
        return Optional.ofNullable(this.getHandleMapping().get(id)).orElseThrow(() -> new HardwareConnectionIssue("Unable to find specified hardware: " + id));
    }

    private void connectClient() throws HardwareConnectionIssue {
        TLINError error = this.dll.connectClient(this.hClient, this.hHardware);
        if (!error.equals((Object)TLINError.ERR_OK)) {
            throw new HardwareConnectionIssue("Unable to connect client to hardware: " + error.name());
        }
    }

    private void initializeHardware(int baud) throws HardwareConnectionIssue {
        TLINError error = this.dll.initializeHardware(this.hClient, this.hHardware, TLINHardwareMode.MASTER, baud);
        if (!error.equals((Object)TLINError.ERR_OK)) {
            throw new HardwareConnectionIssue("Unable to initialize hardware: " + error.name());
        }
    }

    @Override
    public boolean open(String id, int baud) {
        if (this.isOpen) {
            this.console.addConsoleText(Level.SEVERE, "Device is already open.  Must close existing connection before opening a new connection.");
            return false;
        }
        try {
            this.hHardware = this.getHardwareHandle(id);
            this.hClient = this.registerClient();
            this.connectClient();
            this.initializeHardware(baud);
            this.isOpen = true;
        }
        catch (HardwareConnectionIssue exception) {
            this.console.addConsoleText(Level.SEVERE, HARDWARE_CONNECTION_ISSUE);
            this.console.addConsoleText(Level.SEVERE, exception.getMessage());
            this.isOpen = false;
        }
        return this.isOpen;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.dll.deregisterAllFrameIds(this.hClient, this.hHardware);
            this.dll.disconnectClient(this.hClient, this.hHardware);
            this.dll.removeClient(this.hClient);
            this.registeredIds.clear();
            this.isOpen = false;
        }
    }

    @Override
    public boolean write(int id, byte[] data, ChecksumType checksumType) {
        if (!this.isOpen) {
            return false;
        }
        return this.sendRequest(id, data, checksumType, TLINDirection.PUBLISHER);
    }

    private boolean sendRequest(int id, byte[] data, ChecksumType checksumType, TLINDirection direction) {
        TLINMsg message = new TLINMsg(Pid.get((byte)id), (byte)data.length, direction, checksumConverter.get((Object)checksumType), data, 0);
        TLINError error = this.dll.write(this.hClient, this.hHardware, message);
        if (!error.equals((Object)TLINError.ERR_OK)) {
            this.console.addConsoleText(Level.SEVERE, "Device write failed: " + error.name());
            return false;
        }
        this.sleepProvider.sleep(20L);
        return true;
    }

    private boolean registerFrameId(int id) {
        if (this.registeredIds.contains(id)) {
            return true;
        }
        if (this.dll.registerFrameId(this.hClient, this.hHardware, (byte)id, (byte)id).equals((Object)TLINError.ERR_OK)) {
            this.registeredIds.add(id);
        }
        return this.registeredIds.contains(id);
    }

    @Override
    public Optional<byte[]> read(int id, ChecksumType checksumType) {
        if (!this.isOpen) {
            return Optional.empty();
        }
        if (!this.registerFrameId(id)) {
            return Optional.empty();
        }
        if (!this.sendRequest(id, new byte[8], checksumType, TLINDirection.SUBSCRIBER)) {
            return Optional.empty();
        }
        TLINRcvMsg rxMessage = this.dll.read(this.hClient);
        if (rxMessage == null) {
            return Optional.empty();
        }
        if (!rxMessage.errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(rxMessage.data);
    }

    @Override
    public List<String> getIds() {
        Map<String, Integer> handleMapping = this.getHandleMapping();
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(handleMapping.keySet());
        return ids;
    }

    private Map<String, Integer> getHandleMapping() {
        List<Integer> handles = Arrays.stream(this.dll.getHardwareHandles()).boxed().collect(Collectors.toList());
        LinkedHashMap<String, Integer> handleMapping = new LinkedHashMap<String, Integer>();
        handles.forEach(handle -> handleMapping.put("PLIN" + handle, (Integer)handle));
        return handleMapping;
    }

    static {
        checksumConverter.put(ChecksumType.CLASSIC, TLINChecksumType.CLASSIC);
        checksumConverter.put(ChecksumType.ENHANCED, TLINChecksumType.ENHANCED);
    }

    private class HardwareConnectionIssue
    extends Exception {
        public HardwareConnectionIssue(String message) {
            super(message);
        }
    }
}

