/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINChecksumType {
    CUSTOM(0),
    CLASSIC(1),
    ENHANCED(2),
    AUTO(3),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINChecksumType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TLINChecksumType get(int code) {
        TLINChecksumType typeReturn = Arrays.asList(TLINChecksumType.values()).stream().filter(type -> type.getCode() == code).findFirst().orElse(INVALID_CODE);
        if (typeReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid ChecksumType code provided: {0}", code);
        }
        return typeReturn;
    }

    static {
        logger = Logger.getLogger(TLINChecksumType.class.getName());
    }
}

