/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum TLINMsgErrors {
    INCONSISTENT_SYNC(1),
    ID_PARITY_BIT0(2),
    ID_PARITY_BIT1(4),
    SLAVE_NOT_RESPONDING(8),
    TIMEOUT(16),
    CHECKSUM(32),
    GROUND_SHORT(64),
    VBAT_SHORT(128),
    SLOT_DELAY(256),
    OTHER_RESPONSE(512);

    private final int bitMask;

    private TLINMsgErrors(int bitMask) {
        this.bitMask = bitMask;
    }

    private boolean isBitSetFromMask(int code) {
        return (code & this.bitMask) == this.bitMask;
    }

    public static List<TLINMsgErrors> get(int code) {
        return Arrays.asList(TLINMsgErrors.values()).stream().filter(err -> err.isBitSetFromMask(code)).collect(Collectors.toList());
    }
}

