/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINMsgType {
    STANDARD(0),
    BUS_SLEEP(1),
    BUS_WAKE_UP(2),
    AUTOBAUD_RATE_TIMEOUT(3),
    AUTOBAUD_RATE_REPLY(4),
    OVERRUN(5),
    QUEUE_OVERRUN(6),
    CLIENT_QUEUE_OVERRUN(7),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINMsgType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TLINMsgType get(int code) {
        TLINMsgType typeReturn = Arrays.asList(TLINMsgType.values()).stream().filter(type -> type.getCode() == code).findFirst().orElse(INVALID_CODE);
        if (typeReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid TLINMsgType code provided: {0}", code);
        }
        return typeReturn;
    }

    static {
        logger = Logger.getLogger(TLINMsgType.class.getName());
    }
}

