/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.uart;

import console16bit.Console16bit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.util.List;
import java.util.logging.Level;
import unified.bootloader16bit.BadResponseException;
import unified.bootloader16bit.ByteChannelFastImpl;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.ProtocolInUseException;
import unified.bootloader16bit.TimeoutException;
import unified.bootloader16bit.phy.Config;
import unified.bootloader16bit.phy.uart.ConfigImpl;
import unified.bootloader16bit.phy.uart.Controller;
import unified.bootloader16bit.phy.uart.Model;
import unified.bootloader16bit.phy.uart.SerialPortWrapper;
import unified.bootloader16bit.phy.uart.SerialPortWrapperImpl;

public class ProtocolUart
implements Protocol {
    private static final double NANOSECOND_TO_MILLISECOND_DIVISOR = 1000000.0;
    private final ByteBuffer response = ByteBuffer.allocate(1024);
    private ByteChannel channel;
    private final Model model;
    private final Console16bit console;
    private final Config<Model, Controller> config;
    private SerialPortWrapper portWrapper;

    public ProtocolUart(Console16bit console) {
        this(console, new SerialPortWrapperImpl(), new ConfigImpl());
    }

    ProtocolUart(Console16bit console, SerialPortWrapper wrapper, Config<Model, Controller> config) {
        this.console = console;
        this.response.order(ByteOrder.LITTLE_ENDIAN);
        this.portWrapper = wrapper;
        this.model = new Model(this::getPorts);
        this.config = config;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public void config() {
        try {
            this.config.show(this.model);
            this.reportToConsole();
        }
        catch (IOException ex) {
            this.console.addConsoleText(Level.SEVERE, "Unable to load configuration settings window.");
        }
    }

    @Override
    public void close() {
        if (this.portWrapper != null) {
            this.portWrapper.close();
        }
    }

    @Override
    public boolean ready() {
        return this.model.getPort() != null && !this.model.getPort().isEmpty();
    }

    @Override
    public void open() throws ProtocolInUseException, ProtocolException {
        try {
            this.reportToConsole();
            this.portWrapper = this.openSerialPort(this.model.getPort());
            this.channel = new ByteChannelFastImpl(this.portWrapper.getInputStream(), this.portWrapper.getOutputStream());
            this.setUartHardwareParameters(this.portWrapper, this.model.getBaudRate());
            this.flushRxBuffer();
        }
        catch (IOException e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    private SerialPortWrapper openSerialPort(String portName) throws ProtocolInUseException, ProtocolException {
        this.portWrapper.openSerialPortWrapper(portName, this.console);
        return this.portWrapper;
    }

    private void setUartHardwareParameters(SerialPortWrapper serialPort, int baudRate) throws ProtocolException {
        serialPort.setDTR(true);
        serialPort.setRTS(true);
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        serialPort.setDTR(true);
        serialPort.setRTS(true);
    }

    private void flushRxBuffer() throws IOException {
        this.response.clear();
        while (this.channel.read(this.response) > 0) {
            this.response.clear();
        }
    }

    private void write(ByteBuffer commandData) throws IOException {
        int size = commandData.position();
        ByteBuffer request = commandData.duplicate();
        request.flip();
        for (int write = 0; write < size; write += this.channel.write(request)) {
        }
    }

    private ByteBuffer read(Integer expectedDataLength, Integer timeoutMilliseconds) throws IOException, TimeoutException {
        int size = expectedDataLength;
        long t0 = System.nanoTime();
        this.response.clear();
        for (int read = 0; read < size; read += this.channel.read(this.response)) {
            long t1 = System.nanoTime();
            double delta = (double)(t1 - t0) / 1000000.0;
            if (!(delta > (double)timeoutMilliseconds.intValue())) continue;
            this.response.flip();
            byte[] dst = new byte[this.response.capacity()];
            this.response.get(dst);
            throw new TimeoutException(dst);
        }
        this.response.flip();
        return this.response.duplicate();
    }

    @Override
    public ByteBuffer transceive(ByteBuffer commandData, Integer expectedResponseLength, Integer timeoutMilliseconds) throws IOException, TimeoutException, BadResponseException {
        this.write(commandData);
        return this.read(expectedResponseLength, timeoutMilliseconds);
    }

    @Override
    public String getHardwareMisconfigurationMessage() {
        return "Unable to establish communication with device.  Common issues are incorrect configuration UART/Communication port settings on the PC or incorrect UART/Communication port settings on the device.  Please check and retry.";
    }

    public void reportToConsole() {
        this.console.addConsoleText(Level.INFO, "Selected COM Port and Settings: " + this.model.getPort() + ", " + this.model.getBaudRate() + ", 8N1");
    }

    private List<String> getPorts() {
        return this.portWrapper.getPorts();
    }
}

