/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader32bit;

import com.microchip.scf.CommunicationsInterface;
import commands.BootloadDFUFED32bit;
import commands.BootloadUSBDFUFED32bit;
import commands.ICommand;
import console32bit.Console32bit;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.stage.FileChooser;
import observers.ALoraObserver;
import portSettings32bit.PortSettings32bit;
import uartjsscadapter.JSSCSerialPortAdapter;
import udpSettings32bit.UdpSettings32bit;
import udpadapter.UDPAdapter;
import unified.MVController.MVController;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.model32bit.UBootModel32bit;
import unified.bootloader32bit.UBoot32;
import usbSettings32bit.UsbSettings32bit;
import usbhid4javaserviceprovider.Hid4JavaUSBAdapter;

public class UBootFXML32bitController
implements Initializable {
    UBoot32 application;
    JSSCSerialPortAdapter jsscDriverInterface = new JSSCSerialPortAdapter();
    Hid4JavaUSBAdapter usbDriverInterface = new Hid4JavaUSBAdapter();
    UDPAdapter udpDriverInterface = new UDPAdapter();
    CommunicationsInterface commsInterface;
    private static final Logger LOGGER = Logger.getLogger(UBootFXML32bitController.class.getName());
    @FXML
    private Label labelConfig;
    @FXML
    private Label labelProtocol;
    @FXML
    private Label labelSettings;
    @FXML
    private Label labelStatus;
    @FXML
    private Label labelStatusResult;
    @FXML
    private Label labelConfigStatus;
    @FXML
    private ComboBox<String> comboProtocol;
    private final String stringUART = "UART";
    private final String stringUSB = "USB";
    private final String stringUDP = "UDP";
    private final String stringNotConfigured = "Not Configured";
    private final String stringReady = "Ready";
    @FXML
    private Button buttonSettingsConfig;
    @FXML
    private Button buttonProgramDevice;
    @FXML
    private ProgressBar progressBar;
    private static final int SERIAL_TIMEOUT_MS = 50000;
    private static final int UDP_TIMEOUT_MS = 20000;
    private static final int USB_TIMEOUT_MS = 20000;
    int progressBarMax = 100;
    int progressBarCurrent = 1;
    int progressBarStart = 0;
    int mSecTimeOut = 20000;
    FileChooser fileOpenDialog = new FileChooser();
    Console32bit console = null;

    public UBootFXML32bitController(UBoot32 application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.jsscDriverInterface.setTimeOut(50000);
        this.udpDriverInterface.setTimeOut(20000);
        this.application.device.ubootPojo32Bit.setProtocolType("UART");
        this.labelStatusResult.setText("Communication Method: UART");
        this.progressBar.setProgress((double)this.progressBarStart);
        this.labelConfigStatus.setText("Not Configured");
        this.comboProtocol.getItems().add((Object)"UART");
        this.comboProtocol.getItems().add((Object)"USB");
        this.comboProtocol.getItems().add((Object)"UDP");
        this.comboProtocol.getSelectionModel().select((Object)"UART");
        this.comboProtocol.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){
            final UBootFXML32bitController this$0;
            {
                this.this$0 = UBootFXML32bitController.this;
            }

            public void changed(ObservableValue observable, String oldValue, String newValue) {
                UBootFXML32bitController.this.udpDriverInterface.setTimeOut(180000);
                if (newValue != null) {
                    UBootFXML32bitController.this.application.device.ubootPojo32Bit.setProtocolType(newValue);
                }
            }

            public void changed(ObservableValue observablevalue, Object obj, Object obj1) {
                this.changed(observablevalue, (String)obj, (String)obj1);
            }
        });
        this.application.getModel().ubootPojo32Bit.getConsoleState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootFXML32bitController.this.application.getModel().ubootPojo32Bit.getConsoleState().getValue().booleanValue()) {
                    UBootFXML32bitController.this.showConsole();
                }
            }
        });
        this.console = Console32bit.getConsole(this.application);
        this.application.getModel().ubootPojo32Bit.getConfigurationChangedState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootFXML32bitController.this.application.getModel().ubootPojo32Bit.getConfigurationChangedState().getValue().booleanValue()) {
                    UBootFXML32bitController.this.configureSettings();
                }
            }
        });
        this.application.getModel().dfuPojo32Bit.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootFXML32bitController.this.configureLabelUpdate();
            }
        });
        this.application.getModel().usbPojo32Bit.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootFXML32bitController.this.configureLabelUpdate();
            }
        });
        this.application.getModel().udpPojo32Bit.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootFXML32bitController.this.configureLabelUpdate();
            }
        });
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootModel32bit>(){

            @Override
            public void handleEvent(UBootModel32bit value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("WriteBlockSize") == 0) {
                            UBootFXML32bitController.this.progressBarMax = (Integer.parseInt(UBootFXML32bitController.this.application.getModel().ubootPojo32Bit.getProgramMemorySize().replace("0x", ""), 16) - Integer.parseInt(UBootFXML32bitController.this.application.getModel().ubootPojo32Bit.getBootloaderOffset().replace("0x", ""), 16)) / Integer.parseInt(UBootFXML32bitController.this.application.getModel().ubootPojo32Bit.getWriteBlockSize().replace("0x", ""), 16);
                        }
                    }
                });
            }
        });
        this.application.device.addConsolePropertyChangeListener(new ALoraObserver<UBootModel32bit>(){

            @Override
            public void handleEvent(UBootModel32bit value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Progress") == 0) {
                            UBootFXML32bitController.this.progressBar.setProgress((double)UBootFXML32bitController.this.progressBarCurrent / (double)UBootFXML32bitController.this.progressBarMax);
                            ++UBootFXML32bitController.this.progressBarCurrent;
                            UBootFXML32bitController.this.labelStatusResult.setText("Programming Device");
                        }
                        if (whatChanged.compareTo("Console") == 0) {
                            UBootFXML32bitController.this.labelStatusResult.setText("Connection Successful");
                        }
                    }
                });
            }
        });
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootModel32bit>(){

            @Override
            public void handleEvent(UBootModel32bit value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Property") == 0) {
                            UBootFXML32bitController.this.labelStatusResult.setText("Communication Method: " + (String)UBootFXML32bitController.this.comboProtocol.getValue());
                        }
                    }
                });
            }
        });
    }

    private void showConsole() {
        try {
            this.console.init();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to Init Console. " + ex.toString(), ex);
        }
        this.application.getModel().ubootPojo32Bit.setConsoleState(false);
    }

    public void configureSettings() {
        String currentProtocol = (String)this.comboProtocol.getValue();
        if (currentProtocol.contains("UART")) {
            this.configureComSettings();
        } else if (currentProtocol.contains("USB")) {
            this.configureUsbSettings();
        } else if (currentProtocol.contains("UDP")) {
            this.configureUdpSettings();
        }
        this.application.getModel().ubootPojo32Bit.setConfigurationChangedState(false);
    }

    public void configureComSettings() {
        this.commsInterface = this.jsscDriverInterface;
        PortSettings32bit setting = new PortSettings32bit(this.application);
        try {
            this.application.device.dfuPojo32Bit.getComList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.dfuPojo32Bit.getComList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to Configure Com Settings. " + ex.toString(), ex);
        }
    }

    private void configureUsbSettings() {
        this.commsInterface = this.usbDriverInterface;
        this.usbDriverInterface.setTimeOut(this.getTimeout());
        UsbSettings32bit setting = new UsbSettings32bit(this.application);
        try {
            this.application.device.usbPojo32Bit.getDeviceList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.usbPojo32Bit.getDeviceList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to Configure USB Settings. " + ex.toString(), ex);
        }
    }

    private void configureUdpSettings() {
        UdpSettings32bit setting = new UdpSettings32bit(this.application);
        try {
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to Configure UDP Settings. " + ex.toString(), ex);
        }
    }

    @FXML
    void actionConfigure() {
        String protocol = this.application.device.ubootPojo32Bit.getProtocolType().get();
        this.labelConfigStatus.setText("Not Configured");
        this.application.device.dfuPojo32Bit.setConfigured(false);
        this.application.device.usbPojo32Bit.setConfigured(false);
        this.application.device.udpPojo32Bit.setConfigured(false);
        if (protocol.contains("UART")) {
            this.configureComSettings();
        } else if (protocol.contains("USB")) {
            this.configureUsbSettings();
        } else if (protocol.contains("UDP")) {
            this.configureUdpSettings();
        } else {
            this.labelStatusResult.setText("Error Has Occured. Verify Protocol prior to Configuration.");
        }
    }

    void configureLabelUpdate() {
        String protocol = this.application.device.ubootPojo32Bit.getProtocolType().get();
        if (protocol.contains("UART")) {
            try {
                this.commsInterface = this.jsscDriverInterface;
                this.commsInterface.setDeviceName(this.application.device.dfuPojo32Bit.getComPort());
                this.commsInterface.connect();
                this.jsscDriverInterface.setDeviceName(this.application.device.dfuPojo32Bit.getComPort());
                this.jsscDriverInterface.baudRate = Integer.parseInt(this.application.device.dfuPojo32Bit.getBaudRate());
                this.jsscDriverInterface.dataBits = Integer.parseInt(this.application.device.dfuPojo32Bit.getDataBits());
                this.jsscDriverInterface.stopBits = Integer.parseInt(this.application.device.dfuPojo32Bit.getStopBits());
                String readParity = this.application.device.dfuPojo32Bit.getParity();
                if (readParity.contains("Enabled")) {
                    this.jsscDriverInterface.setParity(true);
                } else {
                    this.jsscDriverInterface.setParity(false);
                }
                this.commsInterface.disconnect();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Failed to be able to connect to Serial Interface." + ex.toString(), ex);
            }
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append(this.jsscDriverInterface.getDeviceName());
            statusLabel.append(" @ ");
            statusLabel.append(this.jsscDriverInterface.getBaudRate());
            statusLabel.append(" DB: ");
            statusLabel.append(this.jsscDriverInterface.getStartBits());
            statusLabel.append(" SB: ");
            statusLabel.append(this.jsscDriverInterface.getStopBits());
            statusLabel.append(" Parity: ");
            statusLabel.append(this.jsscDriverInterface.getParity());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else if (protocol.contains("USB")) {
            try {
                this.commsInterface = this.usbDriverInterface;
                this.commsInterface.setDeviceName(this.application.device.usbPojo32Bit.getUsbDevice());
                this.commsInterface.connect();
                this.usbDriverInterface.setDeviceName(this.application.device.usbPojo32Bit.getUsbDevice());
                StringBuilder statusLabel = new StringBuilder();
                statusLabel.append("HID device PID: ");
                statusLabel.append(this.application.device.usbPojo32Bit.getUsbDevice());
                statusLabel.append(" Connected.");
                this.labelConfigStatus.setText(statusLabel.toString());
                this.commsInterface.disconnect();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Failed to be able to connect to USB Interface." + ex.toString(), ex);
            }
        } else if (protocol.contains("UDP")) {
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append("IP Address: ");
            statusLabel.append(this.application.device.udpPojo32Bit.getIpAddress());
            statusLabel.append("     Port: ");
            statusLabel.append(this.application.device.udpPojo32Bit.getIpPort());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else {
            this.labelStatusResult.setText("Error Has Occured. Configuration Bad");
            LOGGER.log(Level.FINE, "UDP Error Has Occured. Configuration Bad");
        }
    }

    @FXML
    void actionProgramDevice() {
        String protocol = this.application.device.ubootPojo32Bit.getProtocolType().get();
        String name = this.application.device.ubootPojo32Bit.getFileName();
        if (name == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error Dialog");
            alert.setHeaderText("Hex File Selection");
            alert.setContentText("HEX file not selected. Could not start programming the device.\nPlease choose a .hex file from the File Menu Dialog.");
            alert.showAndWait();
            return;
        }
        if (protocol.contains("UART")) {
            this.programSerial();
        } else if (protocol.contains("USB")) {
            this.programUSB();
        } else if (protocol.contains("UDP")) {
            this.programUDP();
        }
    }

    void setTimeout(int length) {
        this.mSecTimeOut = length;
    }

    int getTimeout() {
        return this.mSecTimeOut;
    }

    void programSerial() {
        this.progressBarCurrent = 1;
        this.ConnectSerial();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadDFUFED32bit bootload = new BootloadDFUFED32bit();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    void programUSB() {
        this.progressBarCurrent = 1;
        this.ConnectUSB();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadUSBDFUFED32bit bootload = new BootloadUSBDFUFED32bit();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    void programUDP() {
        this.progressBarCurrent = 1;
        this.ConnectUDP();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadDFUFED32bit bootload = new BootloadDFUFED32bit();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    public void ConnectSerial() {
        this.commsInterface = this.jsscDriverInterface;
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.dfuPojo32Bit.getComPort(), new Object[0]));
        try {
            this.commsInterface.connect();
            this.application.startupConnectedDeviceMap.put(this.application.device.dfuPojo32Bit.getComPort(), this.jsscDriverInterface);
            this.application.injectController(new MVController());
            this.application.setDeviceName(this.application.device.dfuPojo32Bit.getComPort());
            this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
            this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
            this.application.injectModelCommunicationInterface(this.jsscDriverInterface);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Creation Failed" + ex.toString(), ex);
        }
    }

    public void ConnectUDP() {
        this.commsInterface = this.udpDriverInterface;
        this.udpDriverInterface.setIpAddress(this.application.device.udpPojo32Bit.getIpAddress());
        Integer portNumber = Integer.parseInt(this.application.device.udpPojo32Bit.getIpPort());
        this.udpDriverInterface.setPort(portNumber);
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.udpPojo32Bit.getIpAddress(), new Object[0]));
        try {
            this.commsInterface.connect();
            this.application.startupConnectedDeviceMap.put(this.application.device.udpPojo32Bit.getIpAddress(), this.udpDriverInterface);
            this.application.injectController(new MVController());
            this.application.setDeviceName(this.application.device.udpPojo32Bit.getIpAddress());
            this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
            this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
            this.application.injectModelCommunicationInterface(this.udpDriverInterface);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Creation Failed" + ex.toString(), ex);
        }
    }

    public void ConnectUSB() {
        this.commsInterface = this.usbDriverInterface;
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.usbPojo32Bit.getUsbDevice(), new Object[0]));
        try {
            this.commsInterface.connect();
            this.application.startupConnectedDeviceMap.put(this.application.device.usbPojo32Bit.getUsbDevice(), this.usbDriverInterface);
            this.application.injectController(new MVController());
            this.application.setDeviceName(this.application.device.usbPojo32Bit.getUsbDevice());
            this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
            this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
            this.application.injectModelCommunicationInterface(this.usbDriverInterface);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Creation Failed" + ex.toString(), ex);
        }
    }

    void handleDisconnect(IDeviceModel dev) {
        LOGGER.log(Level.FINE, String.format("Trying to Disconnect: " + this.application.device.dfuPojo32Bit.getComPort(), new Object[0]));
        try {
            this.commsInterface.disconnect();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Destruction Failed");
        }
    }

    class Success
    implements EventHandler {
        IDeviceModel dev = null;

        public Success(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootFXML32bitController.this.progressBar.setProgress(0.0);
            UBootFXML32bitController.this.handleDisconnect(this.dev);
            UBootFXML32bitController.this.labelStatusResult.setText("Disconnected after Programming was Successful.");
            LOGGER.log(Level.FINE, "Disconnected after Programming was Successful.");
        }
    }

    class Failure
    implements EventHandler {
        IDeviceModel dev = null;

        public Failure(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootFXML32bitController.this.progressBar.setProgress(0.0);
            UBootFXML32bitController.this.handleDisconnect(this.dev);
            UBootFXML32bitController.this.labelStatusResult.setText("Disconnected after Programming Failed.");
            LOGGER.log(Level.SEVERE, "Disconnected after Programming Failed.");
        }
    }
}

