/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableQueue;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;

class RunnableProcessor
implements Runnable {
    private RunnableQueue queue = new RunnableQueue();
    private LinkedList<RunLoopControl> activeRunLoops = new LinkedList();

    RunnableProcessor() {
    }

    @Override
    public void run() {
        this.runLoop();
    }

    void invokeLater(Runnable runnable) {
        this.queue.postRunnable(runnable);
    }

    void invokeAndWait(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.queue.postRunnable(() -> {
            try {
                runnable.run();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Object runLoop() {
        RunLoopControl runLoopControl = new RunLoopControl();
        this.activeRunLoops.push(runLoopControl);
        runLoopControl.active = true;
        while (runLoopControl.active) {
            try {
                this.queue.getNextRunnable().run();
            }
            catch (Throwable throwable) {
                Application.reportException(throwable);
            }
        }
        return runLoopControl.release;
    }

    Object enterNestedEventLoop() {
        Object object = this.runLoop();
        return object;
    }

    void leaveNestedEventLoop(Object object) {
        RunLoopControl runLoopControl = this.activeRunLoops.pop();
        assert (runLoopControl != null);
        runLoopControl.active = false;
        runLoopControl.release = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        RunnableQueue runnableQueue = this.queue;
        synchronized (runnableQueue) {
            this.queue.clear();
            while (!this.activeRunLoops.isEmpty()) {
                RunLoopControl runLoopControl = this.activeRunLoops.pop();
                runLoopControl.active = false;
            }
            this.queue.notifyAll();
        }
    }

    static void runLater(Runnable runnable) {
        NativePlatformFactory.getNativePlatform().getRunnableProcessor().invokeLater(runnable);
    }

    private static class RunLoopControl {
        boolean active;
        Object release;

        private RunLoopControl() {
        }
    }
}

