/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.swt.CustomTransfer;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTView;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class SWTClipboard
extends SystemClipboard {
    Clipboard clipboard;
    static final String CLIPBOARD_KEY = "SWTClipboard";
    static final boolean MULTIPLE_TRANSFERS = SWT.getPlatform().equals("win32");
    static final int DROP_NONE = 0;
    static final int DROP_COPY = 1;
    static final int DROP_MOVE = 2;
    static final int DROP_LINK = 4;
    private static final boolean MUTIPLE_TRANSFERS = false;
    static Transfer[] StandardTransfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance(), HTMLTransfer.getInstance(), URLTransfer.getInstance(), ImageTransfer.getInstance(), FileTransfer.getInstance()};
    static Transfer[] CustomTransfers = new Transfer[0];
    static int operations = 0;
    static TransferData currentTransferData;
    static TransferData[] transferData;
    static Object currentData;

    public SWTClipboard(String string) {
        super(string);
        if (string.equals("SYSTEM")) {
            Display display = Display.getDefault();
            this.clipboard = (Clipboard)display.getData(CLIPBOARD_KEY);
            if (this.clipboard == null) {
                this.clipboard = new Clipboard(display);
                display.setData(CLIPBOARD_KEY, (Object)this.clipboard);
                display.disposeExec(() -> this.clipboard.dispose());
            }
        }
    }

    static Transfer[] getAllTransfers() {
        Transfer[] transferArray = new Transfer[StandardTransfers.length + CustomTransfers.length];
        System.arraycopy(StandardTransfers, 0, transferArray, 0, StandardTransfers.length);
        System.arraycopy(CustomTransfers, 0, transferArray, StandardTransfers.length, CustomTransfers.length);
        return transferArray;
    }

    static Transfer getCustomTransfer(String string) {
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!((CustomTransfer)CustomTransfers[i]).getMime().equals(string)) continue;
            return CustomTransfers[i];
        }
        CustomTransfer customTransfer = new CustomTransfer(string, string);
        Transfer[] transferArray = new Transfer[CustomTransfers.length + 1];
        System.arraycopy(CustomTransfers, 0, transferArray, 0, CustomTransfers.length);
        transferArray[SWTClipboard.CustomTransfers.length] = customTransfer;
        CustomTransfers = transferArray;
        return customTransfer;
    }

    static Transfer[] getTransferTypes(String[] stringArray) {
        int n = 0;
        Transfer[] transferArray = new Transfer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Transfer transfer = SWTClipboard.getTransferType(stringArray[i]);
            if (transfer == null) continue;
            transferArray[n++] = transfer;
        }
        if (n != stringArray.length) {
            Transfer[] transferArray2 = new Transfer[n];
            System.arraycopy(transferArray, 0, transferArray2, 0, n);
            transferArray = transferArray2;
        }
        return transferArray;
    }

    static String getMime(TransferData transferData) {
        if (TextTransfer.getInstance().isSupportedType(transferData)) {
            return "text/plain";
        }
        if (RTFTransfer.getInstance().isSupportedType(transferData)) {
            return "text/rtf";
        }
        if (HTMLTransfer.getInstance().isSupportedType(transferData)) {
            return "text/html";
        }
        if (URLTransfer.getInstance().isSupportedType(transferData)) {
            return "text/uri-list";
        }
        if (ImageTransfer.getInstance().isSupportedType(transferData)) {
            return "application/x-java-rawimage";
        }
        if (FileTransfer.getInstance().isSupportedType(transferData)) {
            return "application/x-java-file-list";
        }
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!CustomTransfers[i].isSupportedType(transferData)) continue;
            return ((CustomTransfer)CustomTransfers[i]).getMime();
        }
        return null;
    }

    static String getMime(Transfer transfer) {
        if (transfer.equals(TextTransfer.getInstance())) {
            return "text/plain";
        }
        if (transfer.equals(RTFTransfer.getInstance())) {
            return "text/rtf";
        }
        if (transfer.equals(HTMLTransfer.getInstance())) {
            return "text/html";
        }
        if (transfer.equals(URLTransfer.getInstance())) {
            return "text/uri-list";
        }
        if (transfer.equals(ImageTransfer.getInstance())) {
            return "application/x-java-rawimage";
        }
        if (transfer.equals(FileTransfer.getInstance())) {
            return "application/x-java-file-list";
        }
        if (transfer instanceof CustomTransfer) {
            return ((CustomTransfer)transfer).getMime();
        }
        return null;
    }

    static String[] getMimes(TransferData[] transferDataArray) {
        int n = 0;
        String[] stringArray = new String[transferDataArray.length];
        for (int i = 0; i < transferDataArray.length; ++i) {
            stringArray[n++] = SWTClipboard.getMime(transferDataArray[i]);
        }
        if (n != stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    static String[] getMimes(Transfer[] transferArray, TransferData transferData) {
        int n = 0;
        String[] stringArray = new String[transferArray.length];
        for (int i = 0; i < transferArray.length; ++i) {
            if (!transferArray[i].isSupportedType(transferData)) continue;
            stringArray[n++] = SWTClipboard.getMime(transferArray[i]);
        }
        if (n != stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    static Transfer getTransferType(String string) {
        if (string.equals("text/plain")) {
            return TextTransfer.getInstance();
        }
        if (string.equals("text/rtf")) {
            return RTFTransfer.getInstance();
        }
        if (string.equals("text/html")) {
            return HTMLTransfer.getInstance();
        }
        if (string.equals("text/uri-list")) {
            return URLTransfer.getInstance();
        }
        if (string.equals("application/x-java-rawimage")) {
            return ImageTransfer.getInstance();
        }
        if (string.equals("application/x-java-file-list")) {
            return FileTransfer.getInstance();
        }
        return SWTClipboard.getCustomTransfer(string);
    }

    static Object getData(String string, TransferData transferData) {
        if (string.equals("text/plain")) {
            return TextTransfer.getInstance().nativeToJava(transferData);
        }
        if (string.equals("text/rtf")) {
            return RTFTransfer.getInstance().nativeToJava(transferData);
        }
        if (string.equals("text/html")) {
            return HTMLTransfer.getInstance().nativeToJava(transferData);
        }
        if (string.equals("text/uri-list")) {
            return URLTransfer.getInstance().nativeToJava(transferData);
        }
        if (string.equals("application/x-java-rawimage")) {
            return ImageTransfer.getInstance().nativeToJava(transferData);
        }
        if (string.equals("application/x-java-file-list")) {
            return FileTransfer.getInstance().nativeToJava(transferData);
        }
        Transfer transfer = SWTClipboard.getCustomTransfer(string);
        if (transfer != null) {
            return ((CustomTransfer)transfer).nativeToJava(transferData);
        }
        return null;
    }

    @Override
    protected boolean isOwner() {
        return false;
    }

    static int getSWTAction(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x40000000) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    static int getFXAction(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 0x40000000;
        }
        return n2;
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> hashMap, int n) {
        Control control;
        Pixels pixels;
        int n2 = 0;
        ImageData imageData = null;
        Set<String> set = hashMap.keySet();
        Control control2 = new Object[set.size()];
        Transfer[] transferArray = new Transfer[set.size()];
        for (String object2 : set) {
            Transfer transfer = SWTClipboard.getTransferType(object2);
            if (transfer == null) continue;
            if (transfer instanceof ImageTransfer && hashMap.get(object2) instanceof Pixels) {
                pixels = (Pixels)hashMap.get(object2);
                imageData = SWTApplication.createImageData(pixels);
                control2[n2] = imageData;
            } else {
                control2[n2] = hashMap.get(object2);
            }
            transferArray[n2] = transfer;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 != ((Object[])control2).length) {
            control = new Object[((Object[])control2).length];
            System.arraycopy(control2, 0, control, 0, ((Object[])control2).length);
            control2 = control;
            Transfer[] transferArray2 = new Transfer[transferArray.length];
            System.arraycopy(transferArray, 0, transferArray2, 0, transferArray.length);
            transferArray = transferArray2;
        }
        if (this.clipboard != null) {
            for (int i = 0; i < transferArray.length; ++i) {
                if (!(transferArray[i] instanceof TextTransfer) || !(control2[i] instanceof String) || ((String)control2[i]).length() != 0) continue;
                this.clipboard.clearContents();
                return;
            }
            this.clipboard.setContents((Object[])control2, transferArray);
        } else {
            control = Display.getDefault().getFocusControl();
            if (control != null && control.getData() instanceof SWTView) {
                SWTView sWTView = (SWTView)control.getData();
                int n3 = SWTClipboard.getSWTAction(n);
                pixels = new DragSource(control, n3);
                pixels.setTransfer(transferArray);
                pixels.setData("objects", control2);
                pixels.setData("imageData", imageData);
                pixels.addDragListener(new DragSourceListener((DragSource)pixels, sWTView, control){
                    Image image = null;
                    final /* synthetic */ DragSource val$dragSource;
                    final /* synthetic */ SWTView val$view;
                    final /* synthetic */ Control val$control;
                    {
                        this.val$dragSource = dragSource;
                        this.val$view = sWTView;
                        this.val$control = control;
                    }

                    public void dragFinished(DragSourceEvent dragSourceEvent) {
                        if (this.image != null) {
                            this.image.dispose();
                            this.image = null;
                        }
                        this.val$dragSource.setData("objects", null);
                        this.val$dragSource.setData("imageData", null);
                        this.val$dragSource.dispose();
                        this.val$view.notifyDragEnd(SWTClipboard.getFXAction(dragSourceEvent.detail));
                    }

                    public void dragSetData(DragSourceEvent dragSourceEvent) {
                        Object[] objectArray = (Object[])this.val$dragSource.getData("objects");
                        Transfer[] transferArray = this.val$dragSource.getTransfer();
                        for (int i = 0; i < transferArray.length; ++i) {
                            String string;
                            if (transferArray[i].isSupportedType(dragSourceEvent.dataType) && (string = SWTClipboard.getMime(transferArray[i])) != null) {
                                dragSourceEvent.doit = true;
                                dragSourceEvent.data = objectArray[i];
                                return;
                            }
                            dragSourceEvent.doit = false;
                        }
                    }

                    public void dragStart(DragSourceEvent dragSourceEvent) {
                        ImageData imageData = (ImageData)this.val$dragSource.getData("imageData");
                        if (imageData != null) {
                            dragSourceEvent.image = this.image = new Image((Device)dragSourceEvent.display, imageData);
                            dragSourceEvent.offsetX = imageData.width / 2;
                            dragSourceEvent.offsetY = imageData.height / 2;
                        }
                        Point point = this.val$control.toDisplay(dragSourceEvent.x, dragSourceEvent.y);
                        this.val$view.notifyDragStart(1, dragSourceEvent.x, dragSourceEvent.y, point.x, point.y);
                    }
                });
                if (sWTView.dropTarget != null) {
                    sWTView.dropTarget.setTransfer(SWTClipboard.getAllTransfers());
                }
                control.notifyListeners(29, null);
            }
        }
    }

    @Override
    protected void pushTargetActionToSystem(int n) {
    }

    @Override
    protected Object popFromSystem(String string) {
        Transfer transfer = SWTClipboard.getTransferType(string);
        if (transfer != null) {
            Object object = null;
            if (this.clipboard != null) {
                object = this.clipboard.getContents(transfer);
            } else if (MULTIPLE_TRANSFERS) {
                for (int i = 0; i < transferData.length; ++i) {
                    if (!transfer.isSupportedType(transferData[i])) continue;
                    object = SWTClipboard.getData(string, transferData[i]);
                    break;
                }
            } else {
                object = currentData;
            }
            if (object instanceof ImageData) {
                return SWTApplication.createPixels((ImageData)object);
            }
            return object;
        }
        return null;
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        if (this.clipboard != null) {
            return 1;
        }
        return SWTClipboard.getFXAction(operations);
    }

    static DropTarget createDropTarget(final Control control) {
        final SWTView sWTView = (SWTView)control.getData();
        final DropTarget dropTarget = new DropTarget(control, 7);
        dropTarget.setTransfer(SWTClipboard.getAllTransfers());
        dropTarget.addDropListener(new DropTargetListener(){
            int detail = 0;

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                dropTarget.setTransfer(SWTClipboard.getAllTransfers());
                this.detail = dropTargetEvent.detail;
                operations = dropTargetEvent.operations;
                this.dragOver(dropTargetEvent, true, this.detail);
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
                operations = 0;
                this.detail = 0;
                currentData = null;
                transferData = null;
                currentTransferData = null;
                sWTView.notifyDragLeave();
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                this.detail = dropTargetEvent.detail;
                operations = dropTargetEvent.operations;
                this.dragOver(dropTargetEvent, false, this.detail);
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                operations = dropTargetEvent.operations;
                this.dragOver(dropTargetEvent, false, this.detail);
            }

            public void dragOver(DropTargetEvent dropTargetEvent, boolean bl, int n) {
                transferData = dropTargetEvent.dataTypes;
                currentTransferData = dropTargetEvent.currentDataType;
                Point point = control.toControl(dropTargetEvent.x, dropTargetEvent.y);
                if (n == 0) {
                    n = 1;
                }
                int n2 = SWTClipboard.getFXAction(n);
                int n3 = bl ? sWTView.notifyDragEnter(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, n2) : sWTView.notifyDragOver(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, n2);
                dropTargetEvent.detail = SWTClipboard.getSWTAction(n3);
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                this.detail = dropTargetEvent.detail;
                operations = dropTargetEvent.operations;
                currentData = dropTargetEvent.data;
                transferData = dropTargetEvent.dataTypes;
                currentTransferData = dropTargetEvent.currentDataType;
                Point point = control.toControl(dropTargetEvent.x, dropTargetEvent.y);
                int n = SWTClipboard.getFXAction(dropTargetEvent.detail);
                int n2 = sWTView.notifyDragDrop(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, n);
                dropTargetEvent.detail = SWTClipboard.getSWTAction(n2);
                currentData = null;
                transferData = null;
                currentTransferData = null;
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }
        });
        return dropTarget;
    }

    @Override
    protected String[] mimesFromSystem() {
        if (this.clipboard != null) {
            int n = 0;
            TransferData[] transferDataArray = this.clipboard.getAvailableTypes();
            String[] stringArray = new String[transferDataArray.length];
            for (int i = 0; i < transferDataArray.length; ++i) {
                String string = SWTClipboard.getMime(transferDataArray[i]);
                if (string == null) continue;
                stringArray[n++] = string;
            }
            if (n == stringArray.length) {
                return stringArray;
            }
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        if (MULTIPLE_TRANSFERS) {
            return SWTClipboard.getMimes(transferData);
        }
        if (currentTransferData == null) {
            return new String[0];
        }
        return SWTClipboard.getMimes(SWTClipboard.getAllTransfers(), currentTransferData);
    }
}

