/*
 * Decompiled with CFR 0.152.
 */
package udpadapter;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDPAdapter
implements CommunicationsInterface {
    InputStream udpInputStream;
    OutputStream udpOutputStream;
    int toolIndex = -1;
    String deviceName;
    InetAddress addr;
    SocketAddress socketAddress;
    private int serverPortName = 0;
    DatagramSocket socket;
    String deviceIP = null;
    boolean isDeviceConnected = false;
    int timeoutMS;
    private static final Logger LOGGER = Logger.getLogger(UDPAdapter.class.getName());
    protected static String[] protNames = null;

    public synchronized void setParams(String address, int port) {
        this.deviceIP = address;
        this.serverPortName = port;
    }

    public void setPort(int passedPort) {
        this.serverPortName = passedPort;
    }

    public int getPort() {
        return this.serverPortName;
    }

    public void setIpAddress(String passedIP) {
        this.deviceIP = passedIP;
    }

    public String getIpAddress() {
        return this.deviceIP;
    }

    public String[] getAttachedDevices() throws IOException {
        LOGGER.log(Level.SEVERE, "Not supported yet. The device list will be empty. User needs to know the IP-Address to talk to the server.");
        throw new UnsupportedOperationException("Not supported yet. The device list will be empty. User needs to know the IP-Address to talk to the server.");
    }

    public boolean connect() throws IOException {
        try {
            this.addr = InetAddress.getByName(this.deviceIP);
            this.socket = new DatagramSocket();
            this.isDeviceConnected = true;
            this.udpInputStream = new UDPInputStream();
            this.udpOutputStream = new UDPOutputStream();
        }
        catch (SocketException | UnknownHostException ex) {
            this.isDeviceConnected = false;
            LOGGER.log(Level.SEVERE, "Failure to connect. " + ex.toString(), ex);
            throw new SocketException("Failure to connect. " + ex);
        }
        return this.isDeviceConnected;
    }

    public boolean disconnect() throws IOException {
        this.udpInputStream.close();
        this.udpOutputStream.close();
        this.socket.close();
        this.isDeviceConnected = false;
        return true;
    }

    public InputStream getInputStream() throws IOException {
        if (this.udpInputStream != null) {
            return this.udpInputStream;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.udpOutputStream != null) {
            return this.udpOutputStream;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setTimeOut(int timeOutinSeconds) {
        this.timeoutMS = timeOutinSeconds;
    }

    public boolean isOpen() {
        return this.isDeviceConnected;
    }

    private class UDPOutputStream
    extends OutputStream {
        private UDPOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] data = new byte[]{(byte)b};
            DatagramPacket packet = new DatagramPacket(data, data.length, UDPAdapter.this.addr, UDPAdapter.this.serverPortName);
            UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
            UDPAdapter.this.socket.send(packet);
        }

        @Override
        public void write(byte[] b) throws IOException {
            DatagramPacket packet = new DatagramPacket(b, b.length, UDPAdapter.this.addr, UDPAdapter.this.serverPortName);
            UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
            UDPAdapter.this.socket.send(packet);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class UDPInputStream
    extends InputStream {
        private UDPInputStream() {
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] data = new byte[1];
                DatagramPacket reply = new DatagramPacket(data, data.length);
                UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
                UDPAdapter.this.socket.receive(reply);
                LOGGER.log(Level.FINE, "UDPDone");
                return data[1];
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Read Failure. " + ex.toString(), ex);
                throw new IOException("Read Failure. " + ex);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            int byte_count = 0;
            try {
                DatagramPacket reply = new DatagramPacket(b, b.length);
                UDPAdapter.this.socket.setSoTimeout(UDPAdapter.this.timeoutMS);
                UDPAdapter.this.socket.receive(reply);
                byte_count = reply.getLength();
            }
            catch (IOException ex) {
                byte_count = 0;
                LOGGER.log(Level.SEVERE, "Read Length Failure. " + ex.toString(), ex);
                throw new IOException("Read Length Failure. " + ex);
            }
            return byte_count;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

